/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerWithFrame;
import org.snpeff.interval.Transcript;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.Log;

public class Cds
extends Marker
implements MarkerWithFrame {
    private static final long serialVersionUID = 1636197649250882952L;
    byte frame = (byte)-1;

    public Cds() {
        this.type = EffectType.CDS;
    }

    public Cds(Transcript parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.CDS;
    }

    @Override
    public Cds cloneShallow() {
        Cds clone = (Cds)super.cloneShallow();
        clone.frame = this.frame;
        return clone;
    }

    public boolean frameCorrection(int frameCorrection) {
        if (frameCorrection <= 0) {
            return true;
        }
        if (this.size() <= frameCorrection) {
            Log.warning(ErrorWarningType.WARNING_CDS_TOO_SHORT, "CDS too short, cannot correct frame: frame size " + this.size() + ", frame correction " + frameCorrection + ", CDS: " + String.valueOf(this));
            return false;
        }
        if (this.isStrandPlus()) {
            this.start += frameCorrection;
        } else {
            this.end -= frameCorrection;
        }
        this.frame = (byte)((this.frame - frameCorrection) % 3);
        while (this.frame < 0) {
            this.frame = (byte)(this.frame + 3);
        }
        return true;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.frame = (byte)markerSerializer.getNextFieldInt();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.frame;
    }

    @Override
    public void setFrame(int frame) {
        if (frame > 2 || frame < -1) {
            throw new RuntimeException("Invalid frame value: " + frame);
        }
        this.frame = (byte)frame;
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + String.valueOf((Object)this.type) + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + ", frame: " + this.frame;
    }
}

