/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.gtex;

import gnu.trove.list.array.TDoubleArrayList;
import org.snpeff.gtex.Gtex;

public class GtexExperiment {
    Gtex gtex;
    String id;
    String tissueType;
    String tissueTypeDetail;
    TDoubleArrayList values;

    public GtexExperiment(Gtex gtex, String line) {
        this.gtex = gtex;
        this.parse(line);
        this.values = new TDoubleArrayList();
    }

    public GtexExperiment(Gtex gtex, String id, String tissueType, String tissueTypeDetail) {
        this.gtex = gtex;
        this.id = id;
        this.tissueType = tissueType;
        this.tissueTypeDetail = tissueTypeDetail;
        this.values = new TDoubleArrayList();
    }

    public void add(double value) {
        this.values.add(value);
    }

    public Gtex getGtex() {
        return this.gtex;
    }

    public String getId() {
        return this.id;
    }

    public String getTissueType() {
        return this.tissueType;
    }

    public String getTissueTypeDetail() {
        return this.tissueTypeDetail;
    }

    public double getValue(int idx) {
        return this.values.get(idx);
    }

    public double getValue(String geneId) {
        int idx = this.gtex.getIndex(geneId);
        return this.values.get(idx);
    }

    protected void parse(String line) {
        String[] fields = line.split("\t");
        this.id = fields[0];
        this.tissueType = fields[5];
        this.tissueTypeDetail = fields[6];
    }

    public int size() {
        return this.values.size();
    }

    public String toString() {
        return this.id + "\t" + this.tissueType + "\t" + this.tissueTypeDetail;
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this);
        for (int i2 = 0; i2 < this.values.size(); ++i2) {
            sb.append(this.values.get(i2) + "\t");
        }
        return sb.toString();
    }
}

