/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.gsa;

import gnu.trove.list.array.TDoubleArrayList;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.special.Gamma;

public class ScoreList {
    public static final double SIGNIFICANCE_LEVEL_95 = 0.05;
    String geneId;
    TDoubleArrayList scores = new TDoubleArrayList();
    boolean sorted = false;

    public static double chiSquareCDFComplementary(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Gamma.regularizedGammaQ((double)nu / 2.0, chiSquare / 2.0);
    }

    public void add(double score) {
        this.scores.add(score);
    }

    public double avg() {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        double sum = 0.0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sum += this.getScore(i2);
        }
        return sum / (double)this.size();
    }

    public double avgLargestTop(int topN) {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        this.sort();
        double sum = 0.0;
        int min = Math.max(0, this.size() - topN);
        int count = 0;
        int i2 = min;
        while (i2 < this.size()) {
            sum += this.getScore(i2);
            ++i2;
            ++count;
        }
        return sum / (double)count;
    }

    public double avgSmallestTop(int topN) {
        if (this.size() <= 0) {
            return this.getDefaultValue();
        }
        this.sort();
        double sum = 0.0;
        int max = Math.min(this.size(), topN);
        for (int i2 = 0; i2 < max; ++i2) {
            sum += this.getScore(i2);
        }
        return sum / (double)max;
    }

    public double cdf(double p) {
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int idx = this.scores.binarySearch(p);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return (double)idx / (double)this.size();
    }

    public double cdfUpper(double p) {
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int idx = this.scores.binarySearch(p);
        if (idx < 0) {
            idx = -(idx + 1);
        }
        return (double)(this.size() - idx) / (double)this.size();
    }

    protected double getDefaultValue() {
        return 0.0;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public double getScore(int index) {
        return this.scores.get(index);
    }

    public double max() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            max = Math.max(max, this.getScore(i2));
        }
        return max;
    }

    public double min() {
        double min = Double.POSITIVE_INFINITY;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            min = Math.min(min, this.getScore(i2));
        }
        return min;
    }

    public double pValueBonferroni() {
        if (this.scores.size() <= 0) {
            return 1.0;
        }
        return Math.min(1.0, this.min() * (double)this.scores.size());
    }

    public double pValueFdr(double alpha) {
        if (this.size() <= 0) {
            return 1.0;
        }
        int total = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!(this.getScore(i2) > 0.0)) continue;
            ++total;
        }
        double tot = total;
        if (total <= 0) {
            return 1.0;
        }
        this.sort();
        int count = 0;
        double pFdrMax = 0.0;
        for (int i3 = 0; i3 < this.size(); ++i3) {
            double pFdr;
            double pvalue = this.getScore(i3);
            if (!(pvalue > 0.0) || !((pFdr = tot * pvalue / (double)(++count)) <= alpha) && !(pFdr < pFdrMax)) continue;
            pFdrMax = pFdr;
        }
        return pFdrMax;
    }

    public double pValueFisherChi2() {
        if (this.size() <= 0) {
            return 1.0;
        }
        double sum = 0.0;
        int count = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            double pvalue = this.getScore(i2);
            if (!(pvalue > 0.0)) continue;
            sum += Math.log(pvalue);
            ++count;
        }
        if (count <= 0) {
            return 1.0;
        }
        double chi2 = -2.0 * sum;
        int k = 2 * count;
        double pValue = ScoreList.chiSquareCDFComplementary(chi2, k);
        return pValue;
    }

    public double pValueSimes() {
        if (this.size() <= 0) {
            return 1.0;
        }
        int total = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!(this.getScore(i2) > 0.0)) continue;
            ++total;
        }
        double tot = total;
        if (total <= 0) {
            return 1.0;
        }
        this.sort();
        int count = 0;
        double pSimesMin = 1.0;
        for (int i3 = 0; i3 < this.size(); ++i3) {
            double pvalue = this.getScore(i3);
            if (!(pvalue > 0.0)) continue;
            double pSimes = pvalue * tot / (double)(++count);
            pSimesMin = Math.min(pSimesMin, pSimes);
        }
        return pSimesMin;
    }

    public double pValueZScore() {
        if (this.size() <= 0) {
            return 1.0;
        }
        double sum = 0.0;
        int count = 0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            double pvalue = this.getScore(i2);
            if (!(pvalue > 0.0)) continue;
            double z = new NormalDistribution().inverseCumulativeProbability(pvalue);
            sum += z;
            ++count;
        }
        if (count <= 0) {
            return 1.0;
        }
        double zsum = sum / Math.sqrt(count);
        double pValue = new NormalDistribution(0.0, 1.0).cumulativeProbability(zsum);
        return pValue;
    }

    public double quantile(double quantile) {
        if (quantile < 0.0 || quantile > 1.0) {
            throw new RuntimeException("Quantile out of range: " + quantile + " .Expected range [0.0 , 1.0].");
        }
        if (this.size() <= 0) {
            return 1.0;
        }
        this.sort();
        int num = (int)(quantile * (double)this.size());
        return this.scores.get(num);
    }

    public double score(ScoreSummary pvalueSummary) {
        switch (pvalueSummary.ordinal()) {
            case 0: {
                return this.min();
            }
            case 8: {
                return this.max();
            }
            case 1: {
                return this.avg();
            }
            case 2: {
                return this.avgSmallestTop(10);
            }
            case 9: {
                return this.avgLargestTop(10);
            }
            case 3: {
                return this.pValueFisherChi2();
            }
            case 4: {
                return this.pValueZScore();
            }
            case 5: {
                return this.pValueSimes();
            }
            case 6: {
                return this.pValueBonferroni();
            }
            case 7: {
                return this.pValueFdr(0.05);
            }
            case 10: {
                return this.sum();
            }
        }
        throw new RuntimeException("Unimplemented method for summary '" + String.valueOf((Object)pvalueSummary) + "'");
    }

    public void setGeneId(String geneId) {
        this.geneId = geneId;
    }

    public int size() {
        return this.scores.size();
    }

    void sort() {
        if (!this.sorted) {
            this.scores.sort();
            this.sorted = true;
        }
    }

    public double sum() {
        double sum = 0.0;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sum += this.getScore(i2);
        }
        return sum;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.geneId + "\t" + this.size() + "\t");
        for (int i2 = 0; i2 < this.size(); ++i2) {
            sb.append(String.format(" %.2e", this.getScore(i2)));
        }
        return sb.toString();
    }

    public static enum ScoreSummary {
        MIN,
        AVG,
        AVG_MIN_10,
        FISHER_CHI_SQUARE,
        Z_SCORES,
        SIMES,
        BONFERRONI,
        FDR,
        MAX,
        AVG_MAX_10,
        SUM;

    }
}

