/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets.algorithm;

import org.apfloat.Apfloat;
import org.snpeff.geneSets.GeneSet;
import org.snpeff.geneSets.GeneSets;
import org.snpeff.geneSets.algorithm.EnrichmentAlgorithm;
import org.snpeff.probablility.FisherExactTest;
import org.snpeff.util.Log;

public class FisherPValueAlgorithm
extends EnrichmentAlgorithm {
    double threshold = 0.5;

    public FisherPValueAlgorithm(GeneSets geneSets, int numberToSelect) {
        super(geneSets, numberToSelect);
    }

    @Override
    Apfloat pValue(GeneSet geneSet) {
        int k = geneSet.getInterestingGenesCount();
        int N = this.geneSets.getGeneCount();
        int D = this.geneSets.getInterestingGenesCount();
        int n = geneSet.getGeneCount();
        double pValue = FisherExactTest.get().fisherExactTestUp(k, N, D, n, this.threshold);
        if (this.debug) {
            Log.debug("k: " + k + "\tN: " + N + "\tD: " + D + "\tn: " + n + "\tpValue: " + pValue + "\t" + geneSet.getName());
        }
        return new Apfloat(pValue);
    }
}

