/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets;

import java.util.ArrayList;
import java.util.List;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.snpeff.geneSets.GeneSet;
import org.snpeff.util.Log;

public class Result
implements Comparable<Result> {
    private List<GeneSet> geneSets;
    private Apfloat pValue;
    private List<Integer> geneSetCount;

    public Result() {
        this.geneSets = new ArrayList<GeneSet>();
        this.pValue = Apcomplex.ONE;
        this.geneSetCount = new ArrayList<Integer>();
    }

    public Result(GeneSet geneSet, Apfloat pValue, int geneSetCount) {
        this.geneSets = new ArrayList<GeneSet>();
        this.geneSets.add(geneSet);
        this.pValue = pValue;
        this.geneSetCount = new ArrayList<Integer>();
        this.geneSetCount.add(geneSetCount);
    }

    public Result(List<GeneSet> list, double pValue) {
        this.setGeneSets(list);
        this.pValue = new Apfloat(pValue);
        this.geneSetCount = new ArrayList<Integer>();
    }

    public Result(Result res) {
        this.setGeneSets(res.geneSets);
        this.setGeneSetCount(res.geneSetCount);
        this.pValue = res.pValue;
    }

    public void addGeneSetCount(int count) {
        if (count > 0) {
            this.geneSetCount.add(count);
        }
    }

    @Override
    public int compareTo(Result res) {
        if (this.pValue != null && res.pValue != null) {
            return this.pValue.compareTo(res.pValue);
        }
        return 0;
    }

    public List<Integer> getGeneSetCount() {
        return this.geneSetCount;
    }

    public int getGeneSetCountLast() {
        if (this.geneSetCount.size() <= 0) {
            return 0;
        }
        int index = this.geneSetCount.size() - 1;
        return this.geneSetCount.get(index);
    }

    public List<GeneSet> getGeneSets() {
        return this.geneSets;
    }

    public GeneSet getLatestGeneSet() {
        if (this.geneSets == null || this.geneSets.size() == 0) {
            return null;
        }
        return this.geneSets.get(this.geneSets.size() - 1);
    }

    public Apfloat getPvalue() {
        return this.pValue;
    }

    public double getPvalueAdjusted() {
        if (this.geneSetCount.size() != this.geneSets.size()) {
            for (GeneSet gs : this.geneSets) {
                Log.debug("Gene set: " + gs.getName());
            }
            for (Integer c : this.geneSetCount) {
                Log.debug("Gene set count: " + c);
            }
            throw new RuntimeException("Incompatible gene count sizes.\n\tGeneSetCount.size : " + this.geneSetCount.size() + "\n\tGeneSets.size     : " + this.geneSets.size());
        }
        double adj = 1.0;
        for (int i2 = 0; i2 < this.geneSetCount.size(); ++i2) {
            adj *= (double)this.geneSetCount.get(i2).intValue() / (double)(i2 + 1);
        }
        return Math.min(1.0, this.pValue.doubleValue() * adj);
    }

    public double getPvalueDouble() {
        return this.pValue.doubleValue();
    }

    public boolean isEmpty() {
        return this.geneSets.isEmpty();
    }

    public void set(List<GeneSet> geneSets, Apfloat pValue) {
        this.setGeneSets(geneSets);
        this.setPvalue(pValue);
    }

    public void setGeneSetCount(List<Integer> geneSetCount) {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.addAll(geneSetCount);
        this.geneSetCount = l;
    }

    public void setGeneSetCountLast(int count) {
        if (this.geneSetCount.size() <= 0) {
            this.geneSetCount.add(count);
            return;
        }
        int index = this.geneSetCount.size() - 1;
        this.geneSetCount.set(index, count);
    }

    public void setGeneSets(List<GeneSet> newGeneSets) {
        this.geneSets = new ArrayList<GeneSet>();
        this.geneSets.addAll(newGeneSets);
    }

    public void setPvalue(Apfloat pValue) {
        this.pValue = pValue;
    }

    public void setPvalue(double pValue) {
        this.pValue = new Apfloat(pValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Gene sets: " + this.geneSets.size());
        sb.append("\tpValue: " + String.valueOf(this.pValue) + "\t[");
        sb.append("\tpValue.adj: " + this.getPvalueAdjusted() + "\t[");
        sb.append("\t[");
        for (Integer count : this.geneSetCount) {
            sb.append(" " + count);
        }
        sb.append("]\t");
        for (GeneSet gs : this.geneSets) {
            sb.append(" " + gs.getName() + "(" + gs.size() + ")");
        }
        return sb.toString();
    }
}

