/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.geneSets;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.snpeff.geneSets.CompareByValue;
import org.snpeff.geneSets.GeneSet;
import org.snpeff.geneSets.GeneSets;

public class GeneSetsRanked
extends GeneSets {
    private static final long serialVersionUID = -7922357470081599803L;
    int maxRank = 0;
    HashMap<String, Integer> rankByGene = new HashMap();

    public GeneSetsRanked() {
    }

    public GeneSetsRanked(GeneSets geneSets) {
        super(geneSets);
    }

    public GeneSetsRanked(String msigDb) {
        this.loadMSigDb(msigDb, false);
    }

    public boolean add(String gene, int rank) {
        if (rank <= 0) {
            throw new RuntimeException("Rank must be a possitive number: " + rank + ", gene '" + gene + "'");
        }
        boolean ok = true;
        if (!this.genes.contains(gene)) {
            if (debug) {
                System.err.println("WARNING: Trying to add ranked gene. Gene  '" + gene + "' does not exist in GeneSets. " + (this.doNotAddIfNotInGeneSet ? "Ignored." : "Added anyway."));
            }
            ok = false;
            if (this.doNotAddIfNotInGeneSet) {
                return ok;
            }
            this.add(gene);
        }
        this.rankByGene.put(gene, rank);
        this.interestingGenes.add(gene);
        if (this.maxRank < rank) {
            this.maxRank = rank;
        }
        return ok;
    }

    @Override
    public void checkInterestingGenes(Set<String> intGenes) {
        super.checkInterestingGenes(intGenes);
        if (this.rankByGene != null && this.rankByGene.keySet().size() > 0) {
            int maxRankTmp = intGenes.size();
            int[] ranksUsed = new int[maxRankTmp + 1];
            for (int i2 = 0; i2 < maxRankTmp; ++i2) {
                ranksUsed[i2] = 0;
            }
            for (String gene : intGenes) {
                Integer rank = this.rankByGene.get(gene);
                if (rank == null || rank <= 0 || rank > maxRankTmp) {
                    throw new RuntimeException("Invalid rank for gene:" + gene + ", rank:" + rank + "(should be [1," + maxRankTmp + "]");
                }
                int n = rank;
                ranksUsed[n] = ranksUsed[n] + 1;
            }
            for (int rank = 1; rank < maxRankTmp; ++rank) {
                if (ranksUsed[rank] == 1) continue;
                throw new RuntimeException("Rank number " + rank + " is used " + ranksUsed[rank] + " times (should be used exactly 1 time)");
            }
        }
    }

    public int getMaxRank() {
        if (this.maxRank <= 0) {
            for (String gene : this.rankByGene.keySet()) {
                int rank = this.rankByGene.get(gene);
                if (rank <= this.maxRank) continue;
                this.maxRank = rank;
            }
        }
        return this.maxRank;
    }

    public int getRank(String gene) {
        Integer rank = this.rankByGene.get(gene);
        if (rank == null) {
            return 0;
        }
        return rank;
    }

    public HashMap<String, Integer> getRankByGene() {
        return this.rankByGene;
    }

    public int getRankedSetsCount() {
        int count = 0;
        for (GeneSet gs : this) {
            if (gs.rankSum() <= 0L) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isRanked() {
        return true;
    }

    public boolean isRanked(String geneName) {
        return this.rankByGene.containsKey(geneName);
    }

    @Override
    protected boolean isUsed(GeneSet gs) {
        for (String gene : gs) {
            if (this.isInteresting(gene)) {
                return true;
            }
            if (!this.isRanked(gene)) continue;
            return true;
        }
        return true;
    }

    @Override
    protected boolean isUsed(String geneName) {
        return this.isRanked(geneName);
    }

    @Override
    public List<String> loadExperimentalValues(String fileName, boolean maskException) {
        List<String> notFound = super.loadExperimentalValues(fileName, maskException);
        this.rankByValue(false);
        return notFound;
    }

    public int rankByValue(boolean orderAscending) {
        LinkedList geneNames = new LinkedList(this.valueByGene.keySet());
        Collections.sort(geneNames, new CompareByValue(this.valueByGene, orderAscending));
        int rank = 1;
        int errorsRank = 0;
        for (String gene : geneNames) {
            if (this.add(gene, rank++)) continue;
            ++errorsRank;
        }
        if (this.verbose && errorsRank > 0) {
            System.err.println(String.format("Misisng %d genes, out of %d genes ( %.1f %% ).", errorsRank, geneNames.size(), (double)errorsRank * 100.0 / (double)geneNames.size()));
        }
        return errorsRank;
    }

    @Override
    public void reset() {
        super.reset();
        this.rankByGene = new HashMap();
        this.maxRank = 0;
    }
}

