/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.genBank;

import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.genBank.Features;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class GenBank
extends Features {
    public static final int FEATURE_NAME_FIELD_LEN = 20;

    public GenBank(LineFileIterator lineFileIterator) {
        super(lineFileIterator);
    }

    public GenBank(String fileName) {
        super(fileName);
    }

    @Override
    protected boolean isNewFeature(String line) {
        int end = Math.min(20, line.length());
        String featName = line.substring(0, end).trim();
        if (featName.isEmpty()) {
            return false;
        }
        return Gpr.parseIntSafe(featName = featName.split(" ")[0]) <= 0;
    }

    protected void parseFieldLine(String name, String valueOri, int fieldLineNum, int fileLineNum) {
        String value = valueOri.trim();
        switch (name) {
            case "LOCUS": {
                String[] subfields = value.split(" ");
                this.locusName = subfields[0];
                if (subfields.length > 1) {
                    this.sequenceLength = Gpr.parseIntSafe(subfields[1]);
                }
                if (subfields.length > 2) {
                    this.moleculeType = subfields[2];
                }
                if (subfields.length > 3) {
                    this.shape = subfields[3];
                }
                if (subfields.length > 4) {
                    this.division = subfields[4];
                }
                if (subfields.length <= 5) break;
                this.date = subfields[5];
                break;
            }
            case "DEFINITION": {
                this.definition = this.definition + value;
                break;
            }
            case "ACCESSION": {
                this.accession = this.accession + value;
                break;
            }
            case "VERSION": {
                this.version = this.version + value;
                break;
            }
            case "KEYWORDS": {
                this.keywords = this.keywords + value;
                break;
            }
            case "SOURCE": {
                this.source = this.source + value;
                break;
            }
            case "REFERENCE": {
                if (fieldLineNum == 0) {
                    this.references.add(new StringBuffer());
                }
                ((StringBuffer)this.references.get(this.references.size() - 1)).append(value + "\n");
                break;
            }
            case "FEATURES": {
                if (this.featuresStartLine < 0) {
                    this.featuresStartLine = fileLineNum;
                }
                if (fieldLineNum <= 0) break;
                this.featuresStr.append(valueOri + "\n");
                break;
            }
            case "ORIGIN": {
                String[] seq = value.split(" ", 2);
                if (seq.length <= 1) break;
                String s = seq[1].replaceAll("\\s", "");
                this.sequence.append(s);
                break;
            }
            default: {
                if (!debug) break;
                System.err.println("Ignored feature '" + name + "'");
            }
        }
    }

    @Override
    public void readFile() {
        int fieldLineNum = 0;
        String name = null;
        String value = "";
        if (debug) {
            Log.debug("NAME: " + name + "\tvalue: " + value);
        }
        for (String line : this.lineFileIterator) {
            if (line.startsWith("//")) break;
            value = line;
            if (!line.startsWith(" ")) {
                String[] kv = line.split(" ", 2);
                name = kv[0];
                String string = value = kv.length > 1 ? kv[1] : "";
                if (debug) {
                    Log.debug("Line: " + line + "\n\tNAME: " + name + "\tvalue: " + value);
                }
                fieldLineNum = 0;
            }
            if (name == null) continue;
            this.parseFieldLine(name, value, fieldLineNum, this.lineFileIterator.getLineNum());
            ++fieldLineNum;
        }
        this.parseFeatures();
    }
}

