/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.fileIterator.MarkerFileIterator;
import org.snpeff.fileIterator.parser.Parser;
import org.snpeff.interval.Genome;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.snpeff.vcf.VcfHeader;

public class VcfFileIterator
extends MarkerFileIterator<VcfEntry>
implements Parser<VcfEntry> {
    public static final String MISSING = ".";
    private static final String EMPTY = "";
    boolean parseNow = true;
    boolean headeSection = false;
    boolean errorIfUnsorted = false;
    boolean expandIub;
    VcfHeader header = new VcfHeader();
    String chrPrev = "";
    int posPrev = -1;

    public static VcfFileIterator fromString(String vcfLines) {
        VcfFileIterator vcfFileIterator;
        ByteArrayInputStream bais = new ByteArrayInputStream(vcfLines.getBytes("UTF-8"));
        try {
            InputStreamReader isr = new InputStreamReader(bais);
            BufferedReader br = new BufferedReader(isr);
            vcfFileIterator = new VcfFileIterator(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bais.close();
        return vcfFileIterator;
    }

    public VcfFileIterator() {
        super((String)null, 1);
        this.init();
    }

    public VcfFileIterator(BufferedReader reader) {
        super(reader, 1);
        this.init();
    }

    public VcfFileIterator(String fileName) {
        super(fileName, 1);
        this.init();
    }

    public VcfFileIterator(String fileName, Genome genome) {
        super(fileName, genome, 1);
        this.init();
    }

    public List<String> getSampleNames() {
        return this.header.getSampleNames();
    }

    public VcfHeader getVcfHeader() {
        return this.header;
    }

    protected void init() {
        this.expandIub = Config.get() != null ? Config.get().isExpandIub() : true;
    }

    public boolean isExpandIub() {
        return this.expandIub;
    }

    public boolean isHeadeSection() {
        return this.headeSection;
    }

    @Override
    public Collection<VcfEntry> parse(String str) {
        LinkedList<VcfEntry> list = new LinkedList<VcfEntry>();
        list.add(this.parseVcfLine(str));
        return list;
    }

    public VcfEntry parseVcfLine(String line) {
        try {
            if (line.startsWith("#")) {
                this.header.addLine(line);
            } else if (line.length() > 0) {
                return new VcfEntry(this, line, this.lineNum, this.parseNow);
            }
        }
        catch (Throwable t) {
            Log.debug("Fatal error reading file '" + this.fileName + "' (line: " + this.lineNum + "):\n" + line);
            throw new RuntimeException(t);
        }
        return null;
    }

    public String readField(String[] fields, int fieldNum) {
        if (fields.length > fieldNum) {
            if (fields[fieldNum].equals(MISSING)) {
                return EMPTY;
            }
            return fields[fieldNum];
        }
        return EMPTY;
    }

    public VcfHeader readHeader() {
        if (this.nextLine != null && !this.nextLine.startsWith("#")) {
            return this.header;
        }
        try {
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (!this.line.startsWith("#")) {
                    this.nextLine = this.line;
                    return this.header;
                }
                this.header.addLine(this.line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return this.header;
    }

    @Override
    protected VcfEntry readNext() {
        try {
            boolean bl = this.headeSection = this.lineNum == 0;
            while (this.ready()) {
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                VcfEntry vcfEntry = this.parseVcfLine(this.line);
                if (vcfEntry != null) {
                    if (this.errorIfUnsorted && vcfEntry.getChromosomeName().equals(this.chrPrev) && vcfEntry.getStart() < this.posPrev) {
                        throw new RuntimeException("VCF file " + (String)(this.fileName != null ? "'" + this.fileName + "'" : EMPTY) + " is not sorted, genomic position " + this.chrPrev + ":" + (this.posPrev + 1) + " is before " + this.chrPrev + ":" + (vcfEntry.getStart() + 1));
                    }
                    if (this.debug) {
                        Object err = vcfEntry.check();
                        if (vcfEntry.getChromosomeName().equals(this.chrPrev) && vcfEntry.getStart() < this.posPrev) {
                            err = (String)err + "File is not sorted: Position '" + vcfEntry.getChromosomeName() + ":" + (vcfEntry.getStart() + 1) + "' after position '" + this.chrPrev + ":" + (this.posPrev + 1) + "'";
                        }
                        if (!((String)err).isEmpty()) {
                            System.err.println("WARNING: Malformed VCF entry" + (String)(this.fileName != null ? "file '" + this.fileName + "'" : EMPTY) + ", line " + this.lineNum + ":\n\tEntry  : " + String.valueOf(vcfEntry) + "\n\tErrors :\n" + Gpr.prependEachLine("\t\t", err));
                        }
                    }
                    this.chrPrev = vcfEntry.getChromosomeName();
                    this.posPrev = vcfEntry.getStart();
                    return vcfEntry;
                }
                this.headeSection = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading file '" + this.fileName + "'. Line ignored:\n\tLine (" + this.lineNum + "):\t'" + this.line + "'");
        }
        return null;
    }

    @Override
    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setErrorIfUnsorted(boolean errorIfUnsorted) {
        this.errorIfUnsorted = errorIfUnsorted;
    }

    public void setExpandIub(boolean expandIub) {
        this.expandIub = expandIub;
    }

    @Override
    public void setInOffset(int inOffset) {
        throw new RuntimeException("Cannot set input offset on VCF file!");
    }

    public void setParseNow(boolean parseNow) {
        this.parseNow = parseNow;
    }

    public void setVcfHeader(VcfHeader header) {
        this.header = header;
    }
}

