/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.CharBuffer;
import org.snpeff.fileIterator.NullReader;

public class SeekableBufferedReader
extends BufferedReader {
    public static int DEFAULT_BUFFER_SIZE = 65536;
    byte[] buffer;
    int next;
    int last;
    int bufferSize;
    String fileName;
    RandomAccessFile randomAccFile;
    long latestpos;

    public SeekableBufferedReader(String fileName) throws IOException {
        super(new NullReader());
        this.init(fileName, DEFAULT_BUFFER_SIZE);
    }

    public SeekableBufferedReader(String fileName, int bufferSize) throws IOException {
        super(null);
        this.init(fileName, bufferSize);
    }

    @Override
    public void close() throws IOException {
        if (this.randomAccFile != null) {
            this.randomAccFile.close();
            this.randomAccFile = null;
            this.latestpos = -1L;
            this.last = 0;
            this.next = 0;
        }
    }

    public boolean equals(Object arg0) {
        throw new RuntimeException("Unimplemented method!");
    }

    int findNl(int next, int last) {
        for (int i2 = next; i2 < last; ++i2) {
            if (this.buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    public long getFilePointer() {
        return this.latestpos + (long)this.next;
    }

    public int hashCode() {
        throw new RuntimeException("Unimplemented method!");
    }

    void init(String fileName, int bufferSize) throws IOException {
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.next = 0;
        this.last = 0;
        this.open(fileName);
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public void open(String fileName) throws IOException {
        this.fileName = fileName;
        try {
            this.randomAccFile = new RandomAccessFile(fileName, "r");
            this.latestpos = 0L;
            this.last = 0;
            this.next = 0;
        }
        catch (FileNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.randomAccFile.read();
    }

    @Override
    public int read(char[] buff) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public int read(CharBuffer arg0) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = null;
        while (true) {
            if (this.last <= this.next) {
                this.next = 0;
                this.latestpos = this.randomAccFile.getFilePointer();
                this.last = this.randomAccFile.read(this.buffer);
                if (this.last < 0) {
                    return this.removeNewLine(sb);
                }
            }
            int nl = this.findNl(this.next, this.last);
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (nl >= 0) {
                sb.append(new String(this.buffer, this.next, nl - this.next));
                this.next = nl + 1;
                return this.removeNewLine(sb);
            }
            sb.append(new String(this.buffer, this.next, this.last - this.next));
            this.last = this.next;
        }
    }

    @Override
    public boolean ready() throws IOException {
        throw new IOException("Unimplemented method!");
    }

    String removeNewLine(StringBuilder sb) {
        if (sb == null) {
            return null;
        }
        if (sb.length() <= 0) {
            return "";
        }
        char c = sb.charAt(sb.length() - 1);
        while (c == '\r' || c == '\n') {
            sb.deleteCharAt(sb.length() - 1);
            if (sb.length() <= 0) break;
            c = sb.charAt(sb.length() - 1);
        }
        return sb.toString();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Unimplemented method!");
    }

    public void seek(long pos) throws IOException {
        this.randomAccFile.seek(pos);
        this.latestpos = pos;
        this.last = 0;
        this.next = 0;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("Unimplemented method!");
    }

    public String toString() {
        return this.fileName + ":" + this.getFilePointer();
    }
}

