/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.IOException;
import org.snpeff.fileIterator.RegulationFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Regulation;
import org.snpeff.util.Gpr;

public class RegulationBedFileIterator
extends RegulationFileIterator {
    public static final int BED_OFFSET = 0;
    String name = "";
    String cellType = "";

    public RegulationBedFileIterator(String fileName, Genome genome, String name, String cellType) {
        super(fileName, genome, 0);
        this.name = name;
        this.cellType = cellType;
    }

    public RegulationBedFileIterator(String fileName, String name, String cellType) {
        super(fileName, 0);
        this.name = name;
        this.cellType = cellType;
    }

    @Override
    protected Regulation readNext() {
        try {
            while (this.ready()) {
                int start;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\t")).length < 3) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int end = start = this.parsePosition(fields[1]);
                if (fields.length > 2) {
                    end = Gpr.parseIntSafe(fields[2]);
                }
                Object id = "line_" + this.lineNum;
                if (fields.length > 3 && !fields[3].isEmpty()) {
                    id = fields[3];
                }
                return new Regulation(chromo, start, end, false, (String)id, this.name, this.cellType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

