/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.BufferedReader;
import org.snpeff.fileIterator.FileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public abstract class MarkerFileIterator<M extends Marker>
extends FileIterator<M> {
    protected boolean createChromos = true;
    protected Genome genome;
    protected boolean ignoreChromosomeErrors = true;
    protected int inOffset;

    public MarkerFileIterator(BufferedReader reader, int inOffset) {
        super(reader);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
    }

    public MarkerFileIterator(String fileName, Genome genome, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = genome != null ? genome : new Genome("genome");
    }

    public MarkerFileIterator(String fileName, int inOffset) {
        super(fileName);
        this.inOffset = inOffset;
        this.genome = new Genome("genome");
    }

    public Chromosome getChromosome(String chromoName) {
        if (this.createChromos) {
            return this.genome.getOrCreateChromosome(chromoName);
        }
        return this.genome.getChromosome(chromoName);
    }

    public Genome getGenome() {
        return this.genome;
    }

    @Override
    protected void init(String fileName, int inOffset) {
        this.line = null;
        this.lineNum = 0;
        this.next = null;
        this.fileName = fileName;
        if (fileName != null) {
            this.reader = Gpr.reader(fileName);
        }
    }

    public boolean isIgnoreChromosomeErrors() {
        return this.ignoreChromosomeErrors;
    }

    public Markers loadMarkers() {
        Markers list = new Markers();
        list.setName(this.fileName);
        for (Marker t : this) {
            list.add(t);
        }
        this.close();
        return list;
    }

    public int parsePosition(String posStr) {
        return Gpr.parseIntSafe(posStr) - this.inOffset;
    }

    public void sanityCheckChromo(String chromoName, Chromosome chromo) {
        if (chromo == null) {
            if (this.ignoreChromosomeErrors) {
                if (this.verbose) {
                    Log.info("WARNING: Chromosome '" + chromoName + "' not found. File '" + this.fileName + "', line " + this.lineNum);
                }
                return;
            }
            throw new RuntimeException("ERROR: Chromosome '" + chromoName + "' not found! File '" + this.fileName + "', line " + this.lineNum);
        }
    }

    public void setCreateChromos(boolean createChromos) {
        this.createChromos = createChromos;
    }

    public void setIgnoreChromosomeErrors(boolean ignoreChromosomeErrors) {
        this.ignoreChromosomeErrors = ignoreChromosomeErrors;
    }

    public void setInOffset(int inOffset) {
        this.inOffset = inOffset;
    }
}

