/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.util.HashMap;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.vcf.VcfInfoType;

public class GuessTableTypes {
    public static boolean debug = true;
    public static int MIN_LINES = 100000;
    String fileName;
    String headerPrefix = "#";
    String columnSeparator = "\t";
    String subfieldSeparator = ";";
    String[] fieldNames = null;
    VcfInfoType[] types = null;
    boolean[] multipleValues = null;
    HashMap<String, Integer> names2index;

    public GuessTableTypes(String fileName) {
        this.fileName = fileName;
    }

    public boolean foundAllTypes() {
        for (int i2 = 0; i2 < this.types.length; ++i2) {
            if (this.types[i2] != null) continue;
            return false;
        }
        return true;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean[] getMultipleValues() {
        return this.multipleValues;
    }

    public HashMap<String, Integer> getNames2index() {
        return this.names2index;
    }

    public VcfInfoType getType(String fieldName) {
        Integer idx = this.names2index.get(fieldName);
        if (idx == null) {
            return null;
        }
        return this.types[idx];
    }

    public VcfInfoType[] getTypes() {
        return this.types;
    }

    public VcfInfoType guessType(String value) {
        if (value == null || value.isEmpty() || value.equals(".")) {
            return null;
        }
        if (this.isMultiple(value)) {
            String[] values = value.split(this.subfieldSeparator);
            VcfInfoType type = null;
            for (String val : values) {
                VcfInfoType valType = this.guessType(val);
                if (type == null) {
                    type = valType;
                    continue;
                }
                if (valType == null || type == valType) continue;
                return null;
            }
            return type;
        }
        try {
            Long.parseLong(value);
            return VcfInfoType.Integer;
        }
        catch (Exception exception) {
            try {
                Double.parseDouble(value);
                return VcfInfoType.Float;
            }
            catch (Exception exception2) {
                if (value.length() == 1) {
                    return VcfInfoType.Character;
                }
                if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no")) {
                    return VcfInfoType.Flag;
                }
                return VcfInfoType.String;
            }
        }
    }

    public boolean guessTypes() {
        boolean header = true;
        if (this.headerPrefix == null) {
            this.headerPrefix = "";
        }
        LineFileIterator lfi = new LineFileIterator(this.fileName);
        for (String line : lfi) {
            if (header) {
                header = false;
                if (this.headerPrefix.isEmpty() || line.startsWith(this.headerPrefix)) {
                    line = line.substring(this.headerPrefix.length());
                    this.fieldNames = line.split(this.columnSeparator);
                    this.types = new VcfInfoType[this.fieldNames.length];
                    this.multipleValues = new boolean[this.fieldNames.length];
                    this.names2index = new HashMap();
                    for (int i2 = 0; i2 < this.fieldNames.length; ++i2) {
                        this.names2index.put(this.fieldNames[i2], i2);
                    }
                    continue;
                }
                return false;
            }
            if (this.multipleValues == null) {
                throw new RuntimeException("Cannot parse file '" + this.fileName + "'. Missing header?");
            }
            boolean done = true;
            String[] values = line.split(this.columnSeparator);
            for (int i3 = 0; i3 < this.fieldNames.length; ++i3) {
                VcfInfoType type = this.guessType(values[i3]);
                if (this.fieldNames[i3].equals("1000Gp1_AMR_AF") && values[i3] != null) {
                    System.err.println("line: " + lfi.getLineNum() + "\tfield[" + i3 + "]: '" + this.fieldNames[i3] + "'\tfield_type: " + String.valueOf((Object)this.types[i3]) + "'\tvalue_type: " + String.valueOf((Object)type) + "\tdata: '" + values[i3] + "'");
                }
                if (this.types[i3] == null) {
                    this.types[i3] = type;
                } else if (this.types[i3] == VcfInfoType.Integer && type == VcfInfoType.Float) {
                    this.types[i3] = type;
                } else if (type == VcfInfoType.String) {
                    this.types[i3] = type;
                }
                int n = i3;
                this.multipleValues[n] = this.multipleValues[n] | this.isMultiple(values[i3]);
                done &= this.types[i3] != null;
            }
            if (!done || lfi.getLineNum() <= MIN_LINES) continue;
            lfi.close();
            return true;
        }
        lfi.close();
        return false;
    }

    boolean isMultiple(String value) {
        return value.indexOf(this.subfieldSeparator) >= 0;
    }

    public Boolean isMultipleValues(String fieldName) {
        Integer idx = this.names2index.get(fieldName);
        if (idx == null) {
            return null;
        }
        return this.multipleValues[idx];
    }

    public boolean parsedHeader() {
        return this.fieldNames != null;
    }

    public void setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
    }

    public void setSubfieldSeparator(String subfieldSeparator) {
        this.subfieldSeparator = subfieldSeparator;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.fieldNames.length; ++i2) {
            sb.append(this.fieldNames[i2] + "\t" + String.valueOf((Object)this.types[i2]) + (this.multipleValues[i2] ? "\tmultiple" : "") + "\n");
        }
        return sb.toString();
    }
}

