/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import java.util.Collections;
import java.util.LinkedList;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqTools;
import org.snpeff.fastq.FastqTrimmer;

public class FastqTrimmerMedian
extends FastqTrimmer {
    int runningMedianLength;

    public FastqTrimmerMedian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases);
        this.runningMedianLength = runningMedianLength;
    }

    int median(int[] qual, int i2) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        int k = 0;
        int j = i2 - this.runningMedianLength + 1;
        while (k < this.runningMedianLength) {
            if (j >= 0 && j < qual.length) {
                list.add(qual[j]);
            }
            ++k;
            ++j;
        }
        Collections.sort(list);
        int size = list.size();
        int med = 0;
        med = list.size() % 2 == 1 ? (Integer)list.get(size / 2) : ((Integer)list.get(size / 2 - 1) + (Integer)list.get(size / 2)) / 2;
        return med;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        for (int i2 = 0; i2 < qual.length; ++i2) {
            int median = this.median(qual, i2);
            if (median >= this.qualityThreshold) continue;
            return i2;
        }
        return qual.length;
    }
}

