/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import java.util.Collections;
import java.util.LinkedList;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqTools;
import org.snpeff.fastq.FastqTrimmerMedian;

public class FastqTrimmerAdrian
extends FastqTrimmerMedian {
    public FastqTrimmerAdrian(int qualityThreshold, int minBases, int runningMedianLength) {
        super(qualityThreshold, minBases, runningMedianLength);
        this.minBases = minBases;
    }

    @Override
    int trimIndex(Fastq fastq) {
        int i2;
        int[] qual = FastqTools.qualtityArray(fastq);
        for (i2 = 0; i2 < qual.length - this.runningMedianLength; i2 += 2) {
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int k = 1; k <= this.runningMedianLength; ++k) {
                list.add(qual[i2 + k]);
            }
            Collections.sort(list);
            int size = list.size();
            int med = 0;
            med = list.size() % 2 == 1 ? (Integer)list.get(size / 2) : ((Integer)list.get(size / 2 - 1) + (Integer)list.get(size / 2)) / 2;
            if (med < this.qualityThreshold) break;
        }
        if ((i2 -= this.runningMedianLength - 1) > this.minBases) {
            return i2;
        }
        return 0;
    }
}

