/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqBuilder;
import org.snpeff.fastq.FastqTools;

public class FastqTrimmer {
    public static boolean debug = false;
    int qualityThreshold;
    FastqBuilder fastqBuilder;
    int minBases;

    public FastqTrimmer(int qualityThreshold, int minBases) {
        this.qualityThreshold = qualityThreshold;
        this.minBases = minBases;
        this.fastqBuilder = new FastqBuilder();
    }

    public Fastq trim(Fastq fastq) {
        int idx = this.trimIndex(fastq);
        if (idx < this.minBases) {
            idx = 0;
        }
        this.fastqBuilder.withDescription(fastq.getDescription());
        this.fastqBuilder.withVariant(fastq.getVariant());
        this.fastqBuilder.withSequence(fastq.getSequence().substring(0, idx));
        this.fastqBuilder.withQuality(fastq.getQuality().substring(0, idx));
        return this.fastqBuilder.build();
    }

    int trimIndex(Fastq fastq) {
        int[] qual = FastqTools.qualtityArray(fastq);
        for (int i2 = 0; i2 < qual.length; ++i2) {
            if (qual[i2] >= this.qualityThreshold) continue;
            return i2;
        }
        return qual.length;
    }
}

