/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.snpeff.snpEffect.commandLine.CommandLine;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class FastqSplit
implements CommandLine {
    public static final long K = 1024L;
    public static final long M = 0x100000L;
    public static final long G = 0x40000000L;
    public static final long T = 0x10000000000L;
    public static final long P = 0x4000000000000L;
    public static final int BUFFER_SIZE = 0xA00000;
    boolean verbose = false;
    byte[] buffer = new byte[0xA00000];
    String fastqFile;
    String dirName;
    String baseName;
    String ext;
    int numSplits;
    File file;
    RandomAccessFile raf;
    ArrayList<String> splitFileNames = new ArrayList();
    String[] args;

    public static void main(String[] args) {
        FastqSplit fbp = new FastqSplit();
        fbp.parseArgs(args);
        fbp.run();
    }

    void close() {
        try {
            if (this.raf != null) {
                this.raf.close();
                this.raf = null;
            }
            this.file = null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    void error(String message) {
        System.err.println("Error: " + message + "\n");
        System.exit(-1);
    }

    String fileSizeStr(long s) {
        if (s < 1024L) {
            return String.format("%dbytes", s);
        }
        if (s < 0x100000L) {
            return String.format("%.1fKb", 1.0 * (double)s / 1024.0);
        }
        if (s < 0x40000000L) {
            return String.format("%.1fMb", 1.0 * (double)s / 1048576.0);
        }
        if (s < 0x10000000000L) {
            return String.format("%.1fGb", 1.0 * (double)s / 1.073741824E9);
        }
        if (s < 0x4000000000000L) {
            return String.format("%.1fTb", 1.0 * (double)s / 1.099511627776E12);
        }
        return String.format("%.1fPb", 1.0 * (double)s / 1.125899906842624E15);
    }

    int findNl(byte[] buffer, int idx) {
        for (int i2 = idx; i2 < buffer.length; ++i2) {
            if (buffer[i2] != 10) continue;
            return i2;
        }
        return -1;
    }

    long findRecordStart(long pos) {
        try {
            this.raf.seek(pos);
            int len = 0;
            long p = pos;
            while ((len = this.raf.read(this.buffer)) > 0) {
                int idx = 0;
                while (idx >= 0) {
                    if ((idx = this.findNl(this.buffer, idx)) < 0 || ++idx >= this.buffer.length || this.buffer[idx] != 64 || !this.isRecordStart(this.buffer, idx)) continue;
                    long recordStart = p + (long)idx;
                    return recordStart;
                }
                p += (long)len;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return -1L;
    }

    @Override
    public String[] getArgs() {
        return this.args;
    }

    public ArrayList<String> getSplitFileNames() {
        return this.splitFileNames;
    }

    boolean isRecordStart(byte[] buffer, int idx) {
        int next = this.findNl(buffer, idx);
        if (next < 0) {
            return false;
        }
        return ++next < buffer.length && buffer[next] != 64;
    }

    void open() {
        this.dirName = Gpr.dirName(this.fastqFile);
        this.ext = Gpr.extName(this.fastqFile);
        this.baseName = Gpr.baseName(this.fastqFile, "." + this.ext);
        try {
            this.file = new File(this.fastqFile);
            if (!this.file.canRead()) {
                this.error("Cannot read file '" + this.fastqFile + "'");
            }
            this.raf = new RandomAccessFile(this.file, "r");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void parseArgs(String[] args) {
        this.args = args;
        int i2 = 0;
        if (args[0].equals("-v")) {
            this.verbose = true;
            ++i2;
        }
        if (args.length - i2 != 2) {
            this.usage(null);
        }
        this.numSplits = Gpr.parseIntSafe(args[i2++]);
        this.fastqFile = args[i2++];
        if (this.numSplits <= 1) {
            this.usage("Number of splits should be more than 1.");
        }
    }

    @Override
    public boolean run() {
        long step;
        this.open();
        long size = this.file.length();
        if (this.verbose) {
            Log.info("Splitting file '" + this.fastqFile + "' into " + this.numSplits + " parts. File size: " + this.fileSizeStr(size) + " ( " + size + " bytes).");
        }
        if ((step = size / (long)this.numSplits) < 0L) {
            this.error("Error: Split file size less than 1 byte!");
        }
        long start = 0L;
        long end = 0L;
        for (int i2 = 0; i2 < this.numSplits; ++i2) {
            start = end;
            end = (long)(i2 + 1) * step;
            end = i2 == this.numSplits - 1 ? size : this.findRecordStart(end);
            this.split(i2, start, end);
        }
        this.close();
        if (this.verbose) {
            Log.info("Done.");
        }
        return true;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void split(int splitNumber, long start, long end) {
        String splitFileName = String.format("%s/%s.%03d.%s", this.dirName, this.baseName, splitNumber, this.ext);
        if (this.dirName == null || this.dirName.isEmpty()) {
            splitFileName = String.format("%s.%03d.%s", this.baseName, splitNumber, this.ext);
        }
        if (this.verbose) {
            Log.info("Split " + splitNumber + ":\t[ " + start + " , " + end + " ]\t=>\t" + splitFileName);
        }
        try {
            FileOutputStream out = new FileOutputStream(new File(splitFileName));
            this.raf.seek(start);
            int len = 0;
            for (long p = start; (len = this.raf.read(this.buffer)) > 0 && p < end; p += (long)len) {
                if (p + (long)len > end) {
                    len = (int)(end - p);
                }
                out.write(this.buffer, 0, len);
            }
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("Usage: " + this.getClass().getSimpleName() + " [-v] numSplits file.fastq\nOptions:\n\t-v\t: Verbose\n");
        System.exit(-1);
    }
}

