/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fastq;

import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqVariant;

public final class FastqBuilder {
    private String description;
    private StringBuilder sequence;
    private StringBuilder quality;
    private FastqVariant variant = DEFAULT_VARIANT;
    public static final FastqVariant DEFAULT_VARIANT = FastqVariant.FASTQ_SANGER;

    public FastqBuilder appendQuality(String quality) {
        if (quality == null) {
            throw new IllegalArgumentException("quality must not be null");
        }
        if (this.quality == null) {
            this.quality = new StringBuilder(quality.length());
        }
        this.quality.append(quality);
        return this;
    }

    public FastqBuilder appendSequence(String sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("sequence must not be null");
        }
        if (this.sequence == null) {
            this.sequence = new StringBuilder(sequence.length());
        }
        this.sequence.append(sequence);
        return this;
    }

    public Fastq build() {
        if (this.description == null) {
            throw new IllegalStateException("description must not be null");
        }
        if (this.sequence == null) {
            throw new IllegalStateException("sequence must not be null");
        }
        if (this.quality == null) {
            throw new IllegalStateException("quality must not be null");
        }
        if (this.variant == null) {
            throw new IllegalStateException("variant must not be null");
        }
        if (!this.sequenceAndQualityLengthsMatch()) {
            throw new IllegalStateException("sequence and quality scores must be the same length");
        }
        Fastq fastq = new Fastq(this.description, this.sequence.toString(), this.quality.toString(), this.variant);
        return fastq;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean sequenceAndQualityLengthsMatch() {
        return this.sequence.length() == this.quality.length();
    }

    public FastqBuilder withDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description must not be null");
        }
        this.description = description;
        return this;
    }

    public FastqBuilder withQuality(String quality) {
        if (quality == null) {
            throw new IllegalArgumentException("quality must not be null");
        }
        if (this.quality == null) {
            this.quality = new StringBuilder(quality.length());
        }
        this.quality.replace(0, this.quality.length(), quality);
        return this;
    }

    public FastqBuilder withSequence(String sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException("sequence must not be null");
        }
        if (this.sequence == null) {
            this.sequence = new StringBuilder(sequence.length());
        }
        this.sequence.replace(0, this.sequence.length(), sequence);
        return this;
    }

    public FastqBuilder withVariant(FastqVariant variant) {
        if (variant == null) {
            throw new IllegalArgumentException("variant must not be null");
        }
        this.variant = variant;
        return this;
    }
}

