/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.coverage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;

public class MarkerTypes {
    HashMap<Marker, String> marker2type = new HashMap();
    HashSet<String> markerTypesClass = new HashSet();

    public void addType(Marker marker, String type) {
        this.marker2type.put(marker, type);
        this.markerTypesClass.add(type);
    }

    public String getSubType(Marker marker) {
        String subtype = null;
        if (marker instanceof Exon) {
            subtype = "Exon:" + String.valueOf((Object)((Exon)marker).getSpliceType());
        } else if (marker instanceof Intron) {
            subtype = "Intron:" + ((Intron)marker).getSpliceType();
        }
        if (subtype != null) {
            this.markerTypesClass.add(subtype);
        }
        return subtype;
    }

    public String getType(Marker marker) {
        String type = this.marker2type.get(marker);
        if (type != null) {
            return type;
        }
        type = marker.getClass().getSimpleName();
        this.markerTypesClass.add(type);
        return type;
    }

    public String getTypeRank(Marker marker) {
        Object typeRank = this.marker2type.get(marker);
        if (typeRank != null) {
            return typeRank;
        }
        if (marker instanceof Exon) {
            Transcript tr = (Transcript)marker.findParent(Transcript.class);
            typeRank = "Exon:" + ((Exon)marker).getRank() + ":" + tr.numChilds();
        } else if (marker instanceof Intron) {
            Transcript tr = (Transcript)marker.findParent(Transcript.class);
            typeRank = "Intron:" + ((Intron)marker).getRank() + ":" + tr.numChilds();
        } else {
            typeRank = marker.getClass().getSimpleName();
        }
        if (typeRank != null) {
            this.markerTypesClass.add((String)typeRank);
        }
        return typeRank;
    }

    public boolean isType(Marker m, String mtype) {
        if (this.getType(m).equals(mtype)) {
            return true;
        }
        String msubtype = this.getSubType(m);
        return msubtype != null && msubtype.equals(mtype);
    }

    boolean isTypeClass(Marker marker) {
        return this.marker2type.get(marker) == null;
    }

    public List<String> markerTypesClass() {
        ArrayList<String> typesList = new ArrayList<String>();
        typesList.addAll(this.markerTypesClass);
        Collections.sort(typesList);
        return typesList;
    }
}

