/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.coverage;

import java.io.Serializable;

public class CoverageChr
implements Serializable {
    private static final long serialVersionUID = -5620938926858131251L;
    short[] count;

    public CoverageChr(int len) {
        this.count = new short[len];
    }

    public double avgCoverage(int start, int end) {
        return (double)this.coverage(start, end) / (double)(end - start + 1);
    }

    public long coverage(int start, int end) {
        long sum = 0L;
        for (int i2 = start; i2 <= end; ++i2) {
            sum += (long)this.count[i2];
        }
        return sum;
    }

    public short[] getCount() {
        return this.count;
    }

    public void inc(int start, int end) {
        for (int i2 = start; i2 <= end; ++i2) {
            if (this.count[i2] >= Short.MAX_VALUE) continue;
            int n = i2;
            this.count[n] = (short)(this.count[n] + 1);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.count.length; ++i2) {
            if (this.count[i2] == 0) continue;
            sb.append(i2 + "\t" + this.count[i2] + "\n");
        }
        return sb.toString();
    }
}

