/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.coverage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.snpeff.coverage.CountReads;
import org.snpeff.coverage.MarkerTypes;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.probablility.Binomial;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.stats.CountByType;
import org.snpeff.stats.CoverageByType;
import org.snpeff.stats.plot.GoogleBarChart;
import org.snpeff.stats.plot.GoogleGeneRegionChart;
import org.snpeff.stats.plot.GoogleGeneRegionNumExonsChart;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class CountReadsOnMarkers {
    public static final int SHOW_EVERY = 10000;
    public static final int MAX_EXONS_CHART = 10;
    public static boolean debug = true;
    boolean verbose = false;
    List<String> fileNames;
    List<String> names;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;
    ArrayList<CountReads> countReadsByFile;
    MarkerTypes markerTypes;
    CountByType readsByFile;

    public CountReadsOnMarkers(SnpEffectPredictor snpEffectPredictor) {
        this.init(snpEffectPredictor);
    }

    public void addFile(String samFileName) {
        this.fileNames.add(samFileName);
        this.names.add(Gpr.removeExt(Gpr.baseName(samFileName)));
    }

    public void addMarkerType(Marker marker, String type) {
        this.markerTypes.addType(marker, type);
    }

    List<Marker> allMarkers() {
        HashSet<Marker> keys = new HashSet<Marker>();
        for (CountReads cr : this.countReadsByFile) {
            keys.addAll(cr.allMarkers());
        }
        ArrayList<Marker> keysSorted = new ArrayList<Marker>(keys.size());
        keysSorted.addAll(keys);
        Collections.sort(keysSorted);
        return keysSorted;
    }

    public void count() {
        this.genome = this.snpEffectPredictor.getGenome();
        for (String fileName : this.fileNames) {
            CountReads countReads = new CountReads(fileName, this.snpEffectPredictor);
            countReads.setMarkerTypes(this.markerTypes);
            countReads.setVerbose(this.verbose);
            countReads.count();
            this.countReadsByFile.add(countReads);
        }
        if (this.verbose) {
            Log.info("Done.");
        }
    }

    CountByType countMarkerTypes(Collection<Marker> markersToCount) {
        CountByType countByMarkerType = new CountByType();
        for (Marker marker : markersToCount) {
            String type = this.markerTypes.getType(marker);
            String subtype = this.markerTypes.getSubType(marker);
            countByMarkerType.inc(type);
            if (subtype == null) continue;
            countByMarkerType.inc(subtype);
        }
        return countByMarkerType;
    }

    public MarkerTypes getMarkerTypes() {
        return this.markerTypes;
    }

    public int getReadLengthAvg() {
        long readLengthCount = 0L;
        long readLengthSum = 0L;
        for (CountReads cr : this.countReadsByFile) {
            readLengthSum += cr.getReadLengthSum();
            readLengthCount += (long)cr.getReadLengthCount();
        }
        if (readLengthCount <= 0L) {
            return 0;
        }
        double rl = (double)readLengthSum / (double)readLengthCount;
        return (int)Math.round(rl);
    }

    public String html() {
        StringBuilder sbHead = new StringBuilder();
        StringBuilder sbBody = new StringBuilder();
        ArrayList<CountByType> countTypesByFile = new ArrayList<CountByType>();
        for (CountReads cr : this.countReadsByFile) {
            countTypesByFile.add(cr.getCountTypes());
        }
        HashSet<String> keySetAll = new HashSet<String>();
        HashSet<String> keySetExon = new HashSet<String>();
        HashSet<String> keySetIntron = new HashSet<String>();
        for (CountByType ct : countTypesByFile) {
            for (String key : ct.keySet()) {
                if (key.startsWith("Exon:")) {
                    keySetExon.add(key);
                    continue;
                }
                if (key.startsWith("Intron:")) {
                    keySetIntron.add(key);
                    continue;
                }
                keySetAll.add(key);
            }
        }
        keySetAll.remove("Chromosome");
        HashMap<String, HashSet<String>> keySets = new HashMap<String, HashSet<String>>();
        keySets.put("", keySetAll);
        keySets.put("Exons", keySetExon);
        keySets.put("Introns", keySetIntron);
        ArrayList keySetNames = new ArrayList();
        keySetNames.addAll(keySets.keySet());
        Collections.sort(keySetNames);
        for (String ksname : keySetNames) {
            HashSet keySet = (HashSet)keySets.get(ksname);
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(keySet);
            Collections.sort(keys);
            if (keys.size() <= 0) continue;
            GoogleBarChart barchart = new GoogleBarChart("Count by file " + ksname);
            barchart.setxLables(keys);
            GoogleBarChart barchartPercent = new GoogleBarChart("Count by file " + ksname + " [Percent]");
            barchartPercent.setxLables(keys);
            for (int i2 = 0; i2 < this.names.size(); ++i2) {
                String name = this.names.get(i2);
                CountByType ct = (CountByType)countTypesByFile.get(i2);
                ArrayList<String> columnValues = new ArrayList<String>();
                for (String key : keys) {
                    if (!keys.contains(key)) continue;
                    columnValues.add("" + ct.get(key));
                }
                barchart.addColumn(name, columnValues);
                barchartPercent.addColumn(name, columnValues);
            }
            sbHead.append(barchart.toStringHtmlHeader());
            sbBody.append(barchart.toStringHtmlBody());
            barchartPercent.percentColumns();
            sbHead.append(barchartPercent.toStringHtmlHeader());
            sbBody.append(barchartPercent.toStringHtmlBody());
        }
        for (int i3 = 0; i3 < this.names.size(); ++i3) {
            String name = this.names.get(i3);
            for (String ksname : keySetNames) {
                HashSet keySet = (HashSet)keySets.get(ksname);
                ArrayList<String> keys = new ArrayList<String>();
                keys.addAll(keySet);
                Collections.sort(keys);
                if (keys.size() <= 0) continue;
                GoogleBarChart barchart = new GoogleBarChart("Count by file " + name + " " + ksname);
                barchart.setxLables(keys);
                CountByType ct = (CountByType)countTypesByFile.get(i3);
                ArrayList<String> columnValues = new ArrayList<String>();
                for (String key : keys) {
                    if (!keys.contains(key)) continue;
                    columnValues.add("" + ct.get(key));
                }
                barchart.addColumn(name, columnValues);
                sbHead.append(barchart.toStringHtmlHeader());
                sbBody.append(barchart.toStringHtmlBody());
            }
        }
        ArrayList<GoogleGeneRegionChart> genRegCharts = new ArrayList<GoogleGeneRegionChart>();
        for (int i4 = 0; i4 < this.names.size(); ++i4) {
            String name = this.names.get(i4);
            CoverageByType cvt = this.countReadsByFile.get(i4).getCoverageByType();
            GoogleGeneRegionChart grc = new GoogleGeneRegionChart(cvt, name);
            genRegCharts.add(grc);
            ArrayList<CoverageByType> coverageByExons = this.countReadsByFile.get(i4).getCoverageByExons();
            for (int exons = 1; exons < coverageByExons.size(); ++exons) {
                CoverageByType cbt = coverageByExons.get(exons);
                if (cbt.isEmpty() || exons > 10) continue;
                GoogleGeneRegionNumExonsChart grcCbt = new GoogleGeneRegionNumExonsChart(cbt, name + " [ " + exons + " exons ]", exons);
                genRegCharts.add(grcCbt);
            }
        }
        for (GoogleGeneRegionChart grc : genRegCharts) {
            sbHead.append(grc.toStringHtmlHeader());
        }
        for (GoogleGeneRegionChart grc : genRegCharts) {
            sbBody.append(grc.toStringHtmlBody());
        }
        return "<head>\n" + sbHead.toString() + "\n</head>\n" + sbBody.toString();
    }

    void init(SnpEffectPredictor snpEffectPredictor) {
        this.fileNames = new ArrayList<String>();
        this.names = new ArrayList<String>();
        this.countReadsByFile = new ArrayList();
        this.markerTypes = new MarkerTypes();
        this.readsByFile = new CountByType();
        this.snpEffectPredictor = snpEffectPredictor != null ? snpEffectPredictor : new SnpEffectPredictor(new Genome());
    }

    public String probabilityTable(CountByType prob) {
        StringBuilder sb = new StringBuilder();
        sb.append("type\tp.binomial");
        for (int j = 0; j < this.countReadsByFile.size(); ++j) {
            sb.append("\treads." + this.names.get(j) + "\texpected." + this.names.get(j) + "\tpvalue." + this.names.get(j));
        }
        sb.append("\n");
        String chrType = Chromosome.class.getSimpleName();
        CountByType countByType = this.countMarkerTypes(this.allMarkers());
        for (String type : countByType.keysSorted()) {
            sb.append(type);
            double p = 0.0;
            if (prob != null && prob.contains(type)) {
                p = prob.getScore(type);
                sb.append("\t" + p);
            } else {
                sb.append("\t\t");
            }
            for (int idx = 0; idx < this.countReadsByFile.size(); ++idx) {
                CountByType countTypesFile = this.countReadsByFile.get(idx).getCountTypes();
                int n = (int)countTypesFile.get(chrType);
                int k = (int)countTypesFile.get(type);
                long expected = Math.round((double)countTypesFile.get(chrType) * p);
                double pvalue = Binomial.get().cdfUpEq(p, k, n);
                long countType = countTypesFile.get(type);
                if (prob != null && prob.contains(type)) {
                    sb.append("\t" + countType + "\t" + expected + "\t" + pvalue);
                    continue;
                }
                sb.append("\t" + countType + "\t\t");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("chr\tstart\tend\ttype\tIDs");
        for (int j = 0; j < this.countReadsByFile.size(); ++j) {
            sb.append("\tReads:" + this.names.get(j) + "\tBases:" + this.names.get(j));
        }
        sb.append("\n");
        for (Marker key : this.allMarkers()) {
            sb.append(key.getChromosomeName() + "\t" + (key.getStart() + 1) + "\t" + (key.getEnd() + 1) + "\t" + key.idChain());
            for (int idx = 0; idx < this.countReadsByFile.size(); ++idx) {
                sb.append("\t" + this.countReadsByFile.get(idx).getCountReads().get(key) + "\t" + this.countReadsByFile.get(idx).getCountBases().get(key));
            }
            sb.append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }
}

