/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.coverage;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.snpeff.coverage.MarkerTypes;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.stats.CountByKey;
import org.snpeff.stats.CountByType;
import org.snpeff.stats.CoverageByType;
import org.snpeff.stats.PosStats;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;

public class CountReads {
    public static int SHOW_EVERY = 10000;
    boolean verbose = false;
    int countTotalReads;
    int readLengthCount;
    int countExceptions = 0;
    long readLengthSum;
    String fileName;
    Genome genome;
    SnpEffectPredictor snpEffectPredictor;
    CountByType countTypes;
    CountByKey<Marker> countReads;
    CountByKey<Marker> countBases;
    MarkerTypes markerTypes;
    CoverageByType coverageByType;
    ArrayList<CoverageByType> coverageByExons;

    public CountReads(String fileName, SnpEffectPredictor snpEffectPredictor) {
        this.fileName = fileName;
        this.snpEffectPredictor = snpEffectPredictor != null ? snpEffectPredictor : new SnpEffectPredictor(new Genome());
        this.markerTypes = new MarkerTypes();
        this.coverageByExons = new ArrayList();
    }

    public void addMarkerType(Marker marker, String type) {
        this.markerTypes.addType(marker, type);
    }

    Collection<Marker> allMarkers() {
        return this.countReads.keySet();
    }

    public void count() {
        this.genome = this.snpEffectPredictor.getGenome();
        this.readLengthSum = 0L;
        this.readLengthCount = 0;
        try {
            if (this.verbose) {
                Log.info("Reading file '" + this.fileName + "'");
            }
            this.countReads = new CountByKey();
            this.countBases = new CountByKey();
            this.countTypes = new CountByType();
            this.coverageByType = new CoverageByType();
            this.countFile(this.fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.verbose) {
            System.err.println("");
            Log.info("Finished reding file " + this.fileName + "\n\tTotal reads: " + this.countTotalReads);
        }
        if (this.verbose) {
            Log.info("Done.");
        }
    }

    void countBedFile(String fileName) {
        int readNum = 1;
        for (Variant read : new BedFileIterator(fileName)) {
            try {
                ++this.readLengthCount;
                this.readLengthSum += (long)read.size();
                this.countMarker(fileName, read);
                if (this.verbose) {
                    Gpr.showMark(readNum, SHOW_EVERY);
                }
                ++readNum;
            }
            catch (Exception e) {
                ++this.countExceptions;
                if (this.countExceptions < 10) {
                    e.printStackTrace();
                    continue;
                }
                if (this.countExceptions != 10) continue;
                System.err.println("Not showing more exceptions!");
            }
        }
    }

    void countFile(String fileName) {
        String fl = fileName.toLowerCase();
        if (fl.endsWith(".bam") || fl.endsWith(".sam")) {
            this.countSamFile(fileName);
        } else if (fl.endsWith(".vcf") || fl.endsWith(".vcf.gz")) {
            this.countVcfFile(fileName);
        } else if (fl.endsWith(".bed") || fl.endsWith(".bed.gz")) {
            this.countBedFile(fileName);
        } else {
            throw new RuntimeException("Unrecognized file extention. Supported types: BAM, SAM, BED, VCF.");
        }
    }

    void countMarker(String fileName, Marker read) {
        Markers regions = this.snpEffectPredictor.queryDeep(read);
        ++this.countTotalReads;
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker m : regions) {
            if (done.contains(m)) continue;
            done.add(m);
            this.countReads.inc(m);
            this.countBases.inc(m, m.intersectSize(read));
            String type = this.markerTypes.getType(m);
            String subtype = this.markerTypes.getSubType(m);
            String typeRank = this.markerTypes.getTypeRank(m);
            this.countTypes.inc(type);
            PosStats posStats = (PosStats)this.coverageByType.getOrCreate(type);
            posStats.sample(read, m);
            this.coverageByExons(read, m, typeRank);
            if (subtype == null) continue;
            this.countTypes.inc(subtype);
            posStats = (PosStats)this.coverageByType.getOrCreate(subtype);
            posStats.sample(read, m);
        }
    }

    CountByType countMarkerTypes(Collection<Marker> markersToCount) {
        CountByType countByMarkerType = new CountByType();
        for (Marker marker : markersToCount) {
            String type = this.markerTypes.getType(marker);
            String subtype = this.markerTypes.getSubType(marker);
            countByMarkerType.inc(type);
            if (subtype == null) continue;
            countByMarkerType.inc(subtype);
        }
        return countByMarkerType;
    }

    void countSamFile(String fileName) {
        int readNum = 1;
        SamReader sam2 = SamReaderFactory.makeDefault().open(new File(fileName));
        for (SAMRecord samRecord : sam2) {
            try {
                Chromosome chr;
                if (!samRecord.getReadUnmappedFlag() && (chr = this.genome.getOrCreateChromosome(samRecord.getReferenceName())) != null) {
                    Marker read = new Marker(chr, samRecord.getAlignmentStart(), samRecord.getAlignmentEnd(), false, "");
                    ++this.readLengthCount;
                    this.readLengthSum += (long)read.size();
                    this.countMarker(fileName, read);
                }
                if (this.verbose) {
                    Gpr.showMark(readNum, SHOW_EVERY);
                }
                ++readNum;
            }
            catch (Exception e) {
                ++this.countExceptions;
                if (this.countExceptions < 10) {
                    e.printStackTrace();
                    continue;
                }
                if (this.countExceptions != 10) continue;
                System.err.println("Not showing more exceptions!");
            }
        }
        try {
            sam2.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing SAM/BAM file '" + fileName + "'", e);
        }
    }

    void countVcfFile(String fileName) {
        int readNum = 1;
        for (VcfEntry read : new VcfFileIterator(fileName)) {
            try {
                ++this.readLengthCount;
                this.readLengthSum += (long)read.size();
                this.countMarker(fileName, read);
                if (this.verbose) {
                    Gpr.showMark(readNum, SHOW_EVERY);
                }
                ++readNum;
            }
            catch (Exception e) {
                ++this.countExceptions;
                if (this.countExceptions < 10) {
                    e.printStackTrace();
                    continue;
                }
                if (this.countExceptions != 10) continue;
                System.err.println("Not showing more exceptions!");
            }
        }
    }

    void coverageByExons(Marker read, Marker m, String typeRank) {
        Transcript tr = (Transcript)m.findParent(Transcript.class);
        if (tr == null) {
            return;
        }
        int exons = tr.numChilds();
        if (this.coverageByExons.size() <= exons) {
            for (int i2 = this.coverageByExons.size(); i2 <= exons; ++i2) {
                this.coverageByExons.add(new CoverageByType());
            }
        }
        CoverageByType cbe = this.coverageByExons.get(exons);
        PosStats posStats = (PosStats)cbe.getOrCreate(typeRank);
        posStats.sample(read, m);
    }

    public CountByKey<Marker> getCountBases() {
        return this.countBases;
    }

    public int getCountExceptions() {
        return this.countExceptions;
    }

    public CountByKey<Marker> getCountReads() {
        return this.countReads;
    }

    public int getCountTotalReads() {
        return this.countTotalReads;
    }

    public CountByType getCountTypes() {
        return this.countTypes;
    }

    public ArrayList<CoverageByType> getCoverageByExons() {
        return this.coverageByExons;
    }

    public CoverageByType getCoverageByType() {
        return this.coverageByType;
    }

    public MarkerTypes getMarkerTypes() {
        return this.markerTypes;
    }

    public int getReadLengthAvg() {
        if (this.readLengthCount <= 0) {
            return 0;
        }
        double rl = (double)this.readLengthSum / (double)this.readLengthCount;
        return (int)Math.round(rl);
    }

    public int getReadLengthCount() {
        return this.readLengthCount;
    }

    public long getReadLengthSum() {
        return this.readLengthSum;
    }

    void init(SnpEffectPredictor snpEffectPredictor) {
    }

    public void setMarkerTypes(MarkerTypes markerTypes) {
        this.markerTypes = markerTypes;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

