/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.complexity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;

public class SequenceComplexity {
    HashMap<Integer, Integer> minCompressedLength = new HashMap();

    public int complexity(String seq) {
        int len = seq.length();
        int comppressLen = this.compressedLength(seq) - this.minCompressedLength(len);
        int complexity = Math.min(comppressLen, len);
        return complexity;
    }

    int compressedLength(String seq) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(seq.length());
        try {
            GZIPOutputStream gz = new GZIPOutputStream(os);
            gz.write(seq.getBytes());
            gz.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return os.toByteArray().length;
    }

    int minCompressedLength(int n) {
        Integer mcl = this.minCompressedLength.get(n);
        if (mcl == null) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < n; ++i2) {
                sb.append('a');
            }
            mcl = this.compressedLength(sb.toString());
            this.minCompressedLength.put(n, mcl);
        }
        return mcl;
    }

    public double ratio(String seq) {
        int measure = this.complexity(seq);
        double ratio = (double)measure / (double)seq.length();
        return ratio;
    }
}

