/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.codons;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import org.snpeff.codons.CodonTable;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.RareAminoAcid;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class FindRareAaIntervals {
    public static final double RARE_THRESHOLD = 1.0E-5;
    boolean verbose = false;
    double rareThreshold = 1.0E-5;
    Genome genome;
    CodonTable codonTable;
    int[] count;
    int countTotal;
    boolean[] isInTable;
    HashMap<String, Transcript> trById;
    HashMap<String, RareAminoAcid> rareAaByPos;

    public FindRareAaIntervals(Genome genome) {
        this.genome = genome;
        this.codonTable = genome.codonTable();
        this.count = new int[90];
        this.isInTable = new boolean[90];
        this.countTotal = 0;
        this.rareAaByPos = new HashMap();
    }

    void addRareAa(Transcript tr, int start, int end) {
        int s = Math.min(start, end);
        int e = Math.max(start, end);
        String key = tr.getChromosomeName() + ":" + s + "-" + e;
        if (this.rareAaByPos.containsKey(key)) {
            return;
        }
        RareAminoAcid raa = new RareAminoAcid(tr, s, e, "");
        this.rareAaByPos.put(key, raa);
    }

    public Collection<RareAminoAcid> findRareAa(String proteinFastaFile) {
        this.isInTable();
        this.proteingFileStats(proteinFastaFile);
        String rare = this.findRareNames();
        if (rare.isEmpty()) {
            return new LinkedList<RareAminoAcid>();
        }
        this.findRareAaSites(proteinFastaFile, rare);
        return this.rareAaByPos.values();
    }

    void findRareAaSites(String id, int aaIdx) {
        Transcript tr;
        if (this.trById == null) {
            this.trById = new HashMap();
            for (Gene gene : this.genome.getGenome().getGenes()) {
                for (Transcript tr2 : gene) {
                    this.trById.put(tr2.getId(), tr2);
                    if (!tr2.hasProteinId()) continue;
                    this.trById.put(tr2.getProteinId(), tr2);
                }
            }
        }
        if ((tr = this.trById.get(id)) == null) {
            Log.warning(ErrorWarningType.WARNING_RARE_AA_POSSITION_NOT_FOUND, "Cannot find transcript '" + id + "'");
            return;
        }
        if (this.verbose) {
            Log.info("Found rare amino acid transcript ID '" + tr.getId() + "'" + (String)(tr.hasProteinId() ? ", protein ID '" + tr.getProteinId() + "'" : ""));
        }
        int[] cds2pos = tr.baseNumberCds2Pos();
        int pos = 0;
        int posPrev = 0;
        int start = -1;
        int step = tr.isStrandPlus() ? 1 : -1;
        for (int cds = aaIdx * 3; cds < (aaIdx + 1) * 3; ++cds) {
            pos = cds2pos[cds];
            if (start < 0) {
                start = pos;
            } else if (pos != posPrev + step) {
                this.addRareAa(tr, start, pos);
                start = -1;
            }
            posPrev = pos;
        }
        if (start >= 0) {
            this.addRareAa(tr, start, pos);
        }
    }

    void findRareAaSites(String proteinFastaFile, String rareAa) {
        char[] rareAaChr = rareAa.toCharArray();
        FastaFileIterator ffi = new FastaFileIterator(proteinFastaFile);
        for (String seq : ffi) {
            for (char aa : rareAaChr) {
                int aaIdx = seq.indexOf(aa);
                if (aaIdx < 0) continue;
                String fastaId = ffi.getIdFromFastaHeader();
                this.findRareAaSites(fastaId, aaIdx);
            }
        }
    }

    String findRareNames() {
        StringBuilder rare = new StringBuilder();
        for (int i2 = 0; i2 < this.count.length; ++i2) {
            double p = (double)this.count[i2] / (double)this.countTotal;
            if (this.count[i2] <= 0 || !(p < this.rareThreshold) && this.isInTable[i2]) continue;
            rare.append((char)i2);
        }
        return rare.toString();
    }

    public double getRareThreshold() {
        return this.rareThreshold;
    }

    void isInTable() {
        for (char c1 : GprSeq.BASES) {
            for (char c2 : GprSeq.BASES) {
                for (char c3 : GprSeq.BASES) {
                    String codon = "" + c1 + c2 + c3;
                    String aa = this.codonTable.aa(codon);
                    this.isInTable[aa.toUpperCase().charAt((int)0)] = true;
                }
            }
        }
    }

    void proteingFileStats(String proteinFastaFile) {
        FastaFileIterator ffi = new FastaFileIterator(proteinFastaFile);
        for (String seq : ffi) {
            for (char c : seq.toUpperCase().toCharArray()) {
                if (!Character.isLetter(c) || c == 'X') continue;
                char c2 = c;
                this.count[c2] = this.count[c2] + 1;
                ++this.countTotal;
            }
        }
    }

    public void setRareThreshold(double rareThreshold) {
        this.rareThreshold = rareThreshold;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.count.length; ++i2) {
            double p = (double)this.count[i2] / (double)this.countTotal;
            if (this.count[i2] <= 0) continue;
            sb.append(String.format("\t%s\t%d\t%.2e\t%b\n", Character.valueOf((char)i2), this.count[i2], p, this.isInTable[i2]));
        }
        return sb.toString();
    }
}

