/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.codons;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.snpeff.codons.CodonTable;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;

public class CodonTables
implements Iterable<CodonTable> {
    public static final String STANDARD_TABLE = "TTT/F, TTC/F, TTA/L, TTG/L, TCT/S, TCC/S, TCA/S, TCG/S, TAT/Y, TAC/Y, TAA/*, TAG/*, TGT/C, TGC/C, TGA/*, TGG/W, CTT/L, CTC/L, CTA/L, CTG/L, CCT/P, CCC/P, CCA/P, CCG/P, CAT/H, CAC/H, CAA/Q, CAG/Q, CGT/R, CGC/R, CGA/R, CGG/R, ATT/I, ATC/I, ATA/I, ATG/M+, ACT/T, ACC/T, ACA/T, ACG/T, AAT/N, AAC/N, AAA/K, AAG/K, AGT/S, AGC/S, AGA/R, AGG/R, GTT/V, GTC/V, GTA/V, GTG/V, GCT/A, GCC/A, GCA/A, GCG/A, GAT/D, GAC/D, GAA/E, GAG/E, GGT/G, GGC/G, GGA/G, GGG/G";
    public static final String STANDARD_TABLE_NAME = "Standard";
    private static final String KEY_SEPARATOR = "_";
    private static final CodonTables codonTables = new CodonTables();
    HashMap<String, CodonTable> codonTableByName = new HashMap();
    HashMap<String, CodonTable> genChr2codonTable = new HashMap();

    public static CodonTables getInstance() {
        return codonTables;
    }

    private CodonTables() {
        CodonTable codonTable = new CodonTable(STANDARD_TABLE_NAME, STANDARD_TABLE);
        this.add(codonTable);
    }

    public String aa(String codon, Genome genome, String chromosome) {
        return this.getTable(genome, chromosome).aa(codon);
    }

    public void add(CodonTable codonTable) {
        this.codonTableByName.put(codonTable.getName(), codonTable);
    }

    public List<String> codon(String aa, Genome genome, String chromosome) {
        return this.getTable(genome, chromosome).codon(aa);
    }

    public CodonTable getTable(Genome genome) {
        String key = genome.getId();
        CodonTable codonTable = this.genChr2codonTable.get(key);
        if (codonTable == null) {
            return codonTables.getTable(STANDARD_TABLE_NAME);
        }
        return codonTable;
    }

    public CodonTable getTable(Genome genome, String chromosome) {
        String key = genome.getId() + KEY_SEPARATOR + chromosome;
        CodonTable codonTable = this.genChr2codonTable.get(key);
        if (codonTable != null) {
            return codonTable;
        }
        return this.getTable(genome);
    }

    public CodonTable getTable(String codonTableName) {
        return CodonTables.getInstance().codonTableByName.get(codonTableName);
    }

    @Override
    public Iterator<CodonTable> iterator() {
        return this.codonTableByName.values().iterator();
    }

    public void set(Genome genome, Chromosome chr, CodonTable codonTable) {
        this.add(codonTable);
        String key = genome.getId() + KEY_SEPARATOR + chr.getId();
        this.genChr2codonTable.put(key, codonTable);
    }

    public void set(Genome genome, CodonTable codonTable) {
        this.add(codonTable);
        String key = genome.getId();
        this.genChr2codonTable.put(key, codonTable);
    }
}

