/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.codons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.snpeff.binseq.coder.DnaCoder;

public class CodonTable {
    public static final String TERMINATION_CODON = "Ter";
    public static final String TERMINATION_CODON_1 = "*";
    private static HashMap<String, String> aa3letter = new HashMap();
    public static final String DEFAULT_START_CODON = "M";
    String name;
    HashMap<String, String> codon2aa;
    HashMap<String, List<String>> aa2codon;
    HashSet<String> startCodons;
    HashSet<String> stopCodons;
    HashMap<String, Integer> degeneracy;

    public CodonTable(String name, String table) {
        this.name = name;
        this.codon2aa = new HashMap();
        this.aa2codon = new HashMap();
        this.startCodons = new HashSet();
        this.stopCodons = new HashSet();
        this.parse(table);
        this.calcDegeneracy();
    }

    public String aa(String codons) {
        return this.aa(codons, false);
    }

    public String aa(String codons, boolean fullProteinSequence) {
        if (codons.isEmpty()) {
            return "";
        }
        char[] bases = codons.toCharArray();
        StringBuilder aas = new StringBuilder();
        int aaNum = 0;
        int i2 = 0;
        while (i2 < bases.length) {
            Object cod = "";
            for (int j = 0; j < 3 && i2 < bases.length; ++j, ++i2) {
                cod = (String)cod + bases[i2];
            }
            String aa = this.codon2aa.get(((String)cod).toUpperCase());
            if (aa == null) {
                aa = "?";
            }
            if (fullProteinSequence && aaNum == 0 && this.isStart((String)cod)) {
                aa = DEFAULT_START_CODON;
            }
            aas.append(aa);
            ++aaNum;
        }
        return aas.toString();
    }

    public String aaThreeLetterCode(char aa) {
        if (aa == '*') {
            return TERMINATION_CODON;
        }
        String aa3 = aa3letter.get(Character.toString(aa).toUpperCase());
        if (aa3 == null) {
            return "???";
        }
        return aa3;
    }

    public String aaThreeLetterCode(String aa) {
        if (aa.length() == 1) {
            return this.aaThreeLetterCode(aa.charAt(0));
        }
        if (aa.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < aa.length(); ++i2) {
            sb.append(this.aaThreeLetterCode(aa.charAt(i2)));
        }
        return sb.toString();
    }

    void calcDegeneracy() {
        this.degeneracy = new HashMap();
        for (char base1 : DnaCoder.TO_BASE) {
            for (char base2 : DnaCoder.TO_BASE) {
                for (char base3 : DnaCoder.TO_BASE) {
                    char[] c = new char[]{base1, base2, base3};
                    String codonStrOld = new String(c);
                    String aaOld = this.aa(codonStrOld);
                    for (int pos = 0; pos < 3; ++pos) {
                        int count = 0;
                        for (char baseNew : DnaCoder.TO_BASE) {
                            char[] codon = new char[]{base1, base2, base3};
                            codon[pos] = baseNew;
                            String codonStrNew = new String(codon);
                            String aaNew = this.aa(codonStrNew);
                            if (!aaOld.equals(aaNew)) continue;
                            ++count;
                        }
                        String key = codonStrOld.toUpperCase() + "_" + pos;
                        this.degeneracy.put(key, count);
                    }
                }
            }
        }
    }

    public List<String> codon(String aa) {
        return this.aa2codon.get(aa.toUpperCase());
    }

    public int degenerate(String codon, int pos) {
        String key = codon.toUpperCase() + "_" + pos;
        Integer degLevel = this.degeneracy.get(key);
        return degLevel != null ? degLevel : -1;
    }

    public String getName() {
        return this.name;
    }

    public boolean isStart(String codon) {
        if (codon.length() == 3) {
            return this.startCodons.contains(codon.toUpperCase());
        }
        for (int i2 = 0; i2 < codon.length(); i2 += 3) {
            int max = Math.min(codon.length(), i2 + 3);
            String codonSigle = codon.substring(i2, max);
            if (!this.startCodons.contains(codonSigle.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isStartFirst(String codon) {
        if (codon.length() < 3) {
            return false;
        }
        return this.isStart(codon.substring(0, 3));
    }

    public boolean isStopAaSymbol(char aaSymbol) {
        return aaSymbol == '*' || aaSymbol == 'X' || aaSymbol == 'x';
    }

    public boolean isStop(String codon) {
        if (codon.length() == 3) {
            return this.stopCodons.contains(codon.toUpperCase());
        }
        for (int i2 = 0; i2 < codon.length(); i2 += 3) {
            int max = Math.min(codon.length(), i2 + 3);
            String codonSigle = codon.substring(i2, max);
            if (!this.stopCodons.contains(codonSigle.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isStopAa(String aas) {
        return aas.indexOf(42) >= 0;
    }

    void parse(String table) {
        String[] entries;
        table = table.toUpperCase().trim();
        for (String entry : entries = table.split(",")) {
            if ((entry = entry.trim()).length() <= 0) continue;
            String[] t = entry.split("/");
            if (t.length == 2) {
                String codon = t[0];
                String aa = t[1];
                if (aa.indexOf(43) >= 0) {
                    this.startCodons.add(codon);
                    aa = aa.replaceAll("\\+", "");
                }
                if (aa.indexOf(42) >= 0) {
                    this.stopCodons.add(codon);
                }
                if (!this.aa2codon.containsKey(aa)) {
                    this.aa2codon.put(aa, new ArrayList());
                }
                this.aa2codon.get(aa).add(codon);
                this.codon2aa.put(codon, aa);
                continue;
            }
            throw new RuntimeException("Error reading codon table. Cannot parse entry: '" + entry + "'\n\tTable: '" + table + "'");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("codon." + this.name + ": ");
        ArrayList<String> codons = new ArrayList<String>();
        codons.addAll(this.codon2aa.keySet());
        Collections.sort(codons);
        for (String codon : codons) {
            sb.append(" " + codon + "/" + this.aa(codon) + (this.isStart(codon) ? "+" : "") + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    static {
        aa3letter.put("A", "Ala");
        aa3letter.put("B", "Asx");
        aa3letter.put("C", "Cys");
        aa3letter.put("D", "Asp");
        aa3letter.put("E", "Glu");
        aa3letter.put("F", "Phe");
        aa3letter.put("G", "Gly");
        aa3letter.put("H", "His");
        aa3letter.put("I", "Ile");
        aa3letter.put("K", "Lys");
        aa3letter.put("L", "Leu");
        aa3letter.put(DEFAULT_START_CODON, "Met");
        aa3letter.put("N", "Asn");
        aa3letter.put("P", "Pro");
        aa3letter.put("Q", "Gln");
        aa3letter.put("R", "Arg");
        aa3letter.put("S", "Ser");
        aa3letter.put("T", "Thr");
        aa3letter.put("U", "Sec");
        aa3letter.put("V", "Val");
        aa3letter.put("W", "Trp");
        aa3letter.put("X", "X");
        aa3letter.put("Y", "Tyr");
        aa3letter.put("Z", "Glx");
        aa3letter.put(TERMINATION_CODON_1, TERMINATION_CODON_1);
    }
}

