/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq.indexer;

import java.util.Iterator;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.comparator.SequenceReference;
import org.snpeff.binseq.comparator.SubsequenceComparator;
import org.snpeff.binseq.indexer.OverlapFilter;
import org.snpeff.binseq.indexer.OverlapRessult;
import org.snpeff.binseq.indexer.SequenceIndexer;
import org.snpeff.collections.HashLongLongArray;
import org.snpeff.nmer.Nmer;
import org.snpeff.util.Gpr;

public class SuffixIndexerNmer<T extends BinarySequence>
extends SequenceIndexer<T> {
    int nmerSize;
    Nmer nmer;
    HashLongLongArray hash;
    OverlapFilter<T> overlapFilter = null;

    public SuffixIndexerNmer(SubsequenceComparator<T> subsequenceComparator, int nmerSize) {
        super(subsequenceComparator);
        this.nmerSize = nmerSize;
        this.nmer = new Nmer(nmerSize);
        this.hash = new HashLongLongArray();
        this.sequences.add(null);
    }

    @Override
    public int add(T sequence) {
        this.sequences.add(sequence);
        int idx = this.sequences.size() - 1;
        this.indexAllSuffix(sequence, idx);
        return idx;
    }

    public OverlapRessult<T> findBestOverlap(T sequence) {
        OverlapRessult result = new OverlapRessult();
        this.findOverlap(sequence, result);
        if (result.bestScore < ((BinarySequence)sequence).length()) {
            BinarySequence sequenceRwc = ((BinarySequence)sequence).reverseWc();
            OverlapRessult resultRwc = new OverlapRessult();
            resultRwc.reverseWC = true;
            this.findOverlap(sequenceRwc, resultRwc);
            if (result.bestSequence == null || result.bestScore < resultRwc.bestScore) {
                result = resultRwc;
                sequence = sequenceRwc;
            }
        }
        return result;
    }

    boolean findOverlap(T sequence, OverlapRessult<T> result) {
        int i2;
        int max = ((BinarySequence)sequence).length() - this.nmerSize;
        this.nmer.setNmer(0L);
        for (i2 = 0; i2 < this.nmerSize; ++i2) {
            this.nmer.rol(((BinarySequence)sequence).getBase(i2));
        }
        i2 = 0;
        while (true) {
            long[] bucket = this.hash.getBucket(this.nmer.getNmer());
            if (result.bestScore >= ((BinarySequence)sequence).length() - i2) break;
            if (bucket != null) {
                int len = this.hash.getBucketLength(this.nmer.getNmer());
                for (int r = 0; r < len; ++r) {
                    long ref = bucket[r];
                    int seqIdx = SequenceReference.getSeqIdx(ref);
                    int start = SequenceReference.getStart(ref);
                    Object seq = this.get(seqIdx);
                    if (this.overlapFilter != null && !this.overlapFilter.considerOverlap(sequence, seq) || i2 != 0 && start != 0 || i2 == 0 && result.bestScore >= ((BinarySequence)seq).length() - start || start == 0 && result.bestScore >= ((BinarySequence)sequence).length() - i2) continue;
                    int score = this.subsequenceComparator.score(sequence, i2, seq, start);
                    if (score > result.bestScore) {
                        result.bestScore = score;
                        result.bestSequence = seq;
                        result.bestReference = ref;
                        result.bestId = seqIdx;
                        result.start = start - i2;
                    }
                    if (score != ((BinarySequence)sequence).length()) continue;
                    return true;
                }
            }
            if (i2 >= max) break;
            this.nmer.rol(((BinarySequence)sequence).getBase(i2 + this.nmerSize));
            ++i2;
        }
        return result.bestSequence != null;
    }

    public OverlapFilter<T> getOverlapFilter() {
        return this.overlapFilter;
    }

    void indexAllSuffix(T sequence, int seqIds) {
        int max = ((BinarySequence)sequence).length() - this.nmerSize;
        this.nmer.setNmer(0L);
        for (int i2 = 0; i2 < this.nmerSize; ++i2) {
            this.nmer.rol(((BinarySequence)sequence).getBase(i2));
        }
        int start = 0;
        while (true) {
            long ref = SequenceReference.getReference(seqIds, start);
            this.hash.put(this.nmer.getNmer(), ref);
            if (start >= max) break;
            this.nmer.rol(((BinarySequence)sequence).getBase(start + this.nmerSize));
            ++start;
        }
    }

    @Override
    public Iterator<T> iterator() {
        Iterator it = this.sequences.iterator();
        it.next();
        return it;
    }

    public boolean overlap(T sequence) {
        OverlapRessult<T> result = this.findBestOverlap(sequence);
        if (result.bestSequence == null) {
            return false;
        }
        if (result.start >= 0 && result.start + ((BinarySequence)sequence).length() <= ((BinarySequence)result.bestSequence).length()) {
            return true;
        }
        BinarySequence overlapSeq = ((BinarySequence)result.bestSequence).overlap((BinarySequence)sequence, result.start);
        this.replaceSequenceOverlap(result.bestSequence, overlapSeq, result.bestId, result.start);
        return true;
    }

    public void printSequences() {
        for (BinarySequence seq : this) {
            System.out.println(seq.getSequence());
        }
    }

    void replaceSequenceOverlap(T sequenceOri, T sequenceNew, int seqIdx, int start) {
        int max = Math.max(((BinarySequence)sequenceNew).length(), ((BinarySequence)sequenceOri).length()) - this.nmerSize;
        if (start >= 0) {
            int startIdx = ((BinarySequence)sequenceOri).length() - this.nmerSize;
            int i2 = 0;
            int j = startIdx;
            while (i2 < this.nmerSize) {
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(j));
                ++i2;
                ++j;
            }
            for (int idx = startIdx; idx < max; ++idx) {
                long ref = SequenceReference.getReference(seqIdx, idx);
                this.hash.put(this.nmer.getNmer(), ref);
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(idx + this.nmerSize));
            }
        } else {
            for (int i3 = 0; i3 < this.nmerSize; ++i3) {
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(i3));
            }
            int idxOri = 0;
            for (int idx = 0; idx < max; ++idx) {
                long ref = SequenceReference.getReference(seqIdx, idx);
                if (0 <= idx && idx < -start) {
                    this.hash.put(this.nmer.getNmer(), ref);
                } else {
                    long refOld = SequenceReference.getReference(seqIdx, idxOri);
                    this.hash.replace(this.nmer.getNmer(), refOld, ref);
                    ++idxOri;
                }
                this.nmer.rol(((BinarySequence)sequenceNew).getBase(idx + this.nmerSize));
            }
        }
        this.sequences.set(seqIdx, sequenceNew);
    }

    public void sanityCheck() {
        int k = 1;
        for (int seqIdx = 1; seqIdx < this.sequences.size(); ++seqIdx) {
            BinarySequence sequence = (BinarySequence)this.sequences.get(seqIdx);
            int max = sequence.length() - this.nmerSize;
            this.nmer.setNmer(0L);
            for (int i2 = 0; i2 < this.nmerSize; ++i2) {
                this.nmer.rol(sequence.getBase(i2));
            }
            for (int start = 0; start < max; ++start) {
                long ref = SequenceReference.getReference(seqIdx, start);
                if (!this.hash.contains(this.nmer.getNmer(), ref)) {
                    throw new RuntimeException("ERROR: Cannot find reference:\n\tReference: " + ref + "\tsequence.id: " + seqIdx + "\tindex: " + start + "\n\tNmer: " + String.valueOf(this.nmer) + "(" + this.nmer.getNmer() + ")\n\tSequence: " + sequence.getSequence());
                }
                this.nmer.rol(sequence.getBase(start + this.nmerSize));
                Gpr.showMarkStderr(k++, 10000);
            }
        }
        k = 1;
        for (long nmerLong : this.hash.keys()) {
            long[] bucket = this.hash.getBucket(nmerLong);
            if (bucket == null) {
                if (nmerLong == 0L) continue;
                throw new RuntimeException("ERROR: Nmer does not have any bucket!\n\tNmer: " + nmerLong);
            }
            int len = this.hash.getLatestBucketLength();
            for (int i3 = 0; i3 < len; ++i3) {
                long ref = bucket[i3];
                int seqIdx = SequenceReference.getSeqIdx(ref);
                int start = SequenceReference.getStart(ref);
                Object sequence = this.get(seqIdx);
                String nmerStr = ((BinarySequence)sequence).getSequence().substring(start, start + this.nmer.length());
                this.nmer.setNmer(nmerLong);
                if (!this.nmer.toString().equalsIgnoreCase(nmerStr)) {
                    throw new RuntimeException("ERROR: Reference does not match Nmer:\n\tNnmer: " + nmerLong + "\tReference: " + ref + "\tsequence.id: " + seqIdx + "\tindex: " + start + "\n\tNmer: " + String.valueOf(this.nmer) + "\n\tSequence: " + ((BinarySequence)sequence).getSequence());
                }
                Gpr.showMarkStderr(k++, 10000);
            }
        }
    }

    public void setOverlapFilter(OverlapFilter<T> overlapFilter) {
        this.overlapFilter = overlapFilter;
    }

    public String toString() {
        long tot = 0L;
        int max = 0;
        StringBuilder sb = new StringBuilder();
        for (BinarySequence seq : this) {
            tot += (long)seq.length();
            max = Math.max(max, seq.length());
        }
        if (this.sequences.size() > 0) {
            sb.append("Max sequence length: " + max + "\tAvg sequence length: " + tot / (long)this.sequences.size());
        }
        sb.append("\tHash stats: " + this.hash.toString());
        return sb.toString();
    }

    public String toStringSequences() {
        StringBuilder sb = new StringBuilder();
        for (BinarySequence seq : this) {
            sb.append(seq.getSequence() + "\n");
        }
        return sb.toString();
    }
}

