/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.DnaSequence;
import org.snpeff.binseq.coder.Coder;
import org.snpeff.binseq.coder.DnaCoder;

public class DnaSequencePe
extends BinarySequence {
    private static final long serialVersionUID = -7267466011654235050L;
    public static final Coder coder = DnaCoder.get();
    DnaSequence seq1;
    DnaSequence seq2;
    int gap;

    public DnaSequencePe(String seqStr) {
        this.set(seqStr);
    }

    public DnaSequencePe(String seqStr1, String seqStr2, int gap) {
        this.seq1 = new DnaSequence(seqStr1);
        this.seq2 = new DnaSequence(seqStr2);
        this.gap = gap;
    }

    @Override
    public int compareTo(BinarySequence o) {
        DnaSequencePe bs = (DnaSequencePe)o;
        int c = this.seq1.compareTo(bs.seq1);
        if (c != 0) {
            return c;
        }
        if (this.gap < bs.gap) {
            return 1;
        }
        if (this.gap > bs.gap) {
            return -1;
        }
        return this.seq2.compareTo(bs.seq2);
    }

    @Override
    public int getCode(int index) {
        if (index < this.seq1.length()) {
            return this.seq1.getCode(index);
        }
        if (index < this.seq1.length() + this.gap) {
            return 0;
        }
        return this.seq2.getCode(index - this.seq1.length() - this.gap);
    }

    @Override
    public Coder getCoder() {
        return coder;
    }

    public int getGap() {
        return this.gap;
    }

    public DnaSequence getSeq1() {
        return this.seq1;
    }

    public DnaSequence getSeq2() {
        return this.seq2;
    }

    @Override
    public String getSequence() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.seq1);
        for (int i2 = 0; i2 < this.gap; ++i2) {
            sb.append('N');
        }
        sb.append(this.seq2);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += this.seq1.hashCode();
        hash += 33 * hash + this.seq2.hashCode();
        hash += 33 * hash + this.gap;
        return hash;
    }

    public int intLen(int len) {
        return len % coder.basesPerWord() != 0 ? len / coder.basesPerWord() + 1 : len / coder.basesPerWord();
    }

    @Override
    public int length() {
        return this.seq1.length() + this.seq2.length() + this.gap;
    }

    @Override
    public DnaSequencePe read(DataInputStream dataInStream) throws IOException {
        DnaSequencePe binSeq = new DnaSequencePe(null, null, 0);
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        this.gap = dataInStream.readInt();
        this.seq1 = new DnaSequence(null);
        this.seq1.readDataStream(dataInStream);
        this.seq2 = new DnaSequence(null);
        this.seq2.readDataStream(dataInStream);
    }

    @Override
    public BinarySequence reverseWc() {
        DnaSequence s2rwc;
        DnaSequencePe seq = new DnaSequencePe(null, null, this.gap);
        DnaSequence s1rwc = (DnaSequence)this.seq1.reverseWc();
        seq.seq1 = s2rwc = (DnaSequence)this.seq2.reverseWc();
        seq.seq2 = s1rwc;
        return seq;
    }

    @Override
    public void set(String seqStr) {
        if (seqStr == null) {
            this.gap = 0;
            this.seq1 = this.seq2 = DnaSequence.empty();
            return;
        }
        String su = seqStr.toUpperCase();
        int idx1 = su.indexOf(78);
        int idx2 = su.lastIndexOf(78);
        this.gap = idx2 - idx1;
        if (idx1 < 0 || this.gap == 0) {
            this.seq1 = new DnaSequence(seqStr);
            this.gap = 0;
            this.seq2 = DnaSequence.empty();
        } else {
            this.seq1 = new DnaSequence(su.substring(0, idx1));
            this.seq2 = new DnaSequence(su.substring(idx2 + 1));
        }
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    public String toString() {
        return this.getSequence();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        dataOutStream.writeInt(this.gap);
        this.seq1.write(dataOutStream);
        this.seq2.write(dataOutStream);
    }
}

