/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

public class DnaSequenceByte {
    public static final int BASES_PER_BYTE = 4;
    public static final int BITS_PER_BASE = 2;
    public static final byte[] MASK = new byte[]{-64, 48, 12, 3};
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    public static final byte[] BASE2CODE = new byte[256];
    int length;
    byte[] codes;

    public DnaSequenceByte(int length, byte[] codes) {
        this.length = length;
        this.codes = codes;
    }

    public DnaSequenceByte(String seqStr) {
        if (seqStr != null) {
            this.set(seqStr);
        }
    }

    public char getBase(int index) {
        int idx = index / 4;
        int pos = index % 4;
        int code = 0xFF & (this.codes[idx] & MASK[pos]);
        int rot = (3 - pos) * 2;
        return BASES[code >>>= rot];
    }

    public byte[] getCodes() {
        return this.codes;
    }

    public int getLength() {
        return this.length;
    }

    public int hashCode() {
        long hash = 0L;
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            hash = hash * 33L + (long)this.codes[i2];
        }
        return (int)hash;
    }

    public int length() {
        return this.length;
    }

    public void set(String seqStr) {
        if (seqStr == null) {
            this.length = 0;
            this.codes = null;
        } else {
            this.length = seqStr.length();
            int ilen = this.length / 4 + (this.length % 4 != 0 ? 1 : 0);
            this.codes = new byte[ilen];
            char[] seqChar = seqStr.toCharArray();
            int j = 0;
            int k = 0;
            int s = 0;
            for (int i2 = 0; i2 < seqChar.length; ++i2) {
                s = (byte)(s << 2);
                s = (byte)(s | BASE2CODE[seqChar[i2]]);
                if (++k < 4) continue;
                this.codes[j] = s;
                k = 0;
                ++j;
                s = 0;
            }
            if (k < 4 && k != 0) {
                this.codes[j] = s = (int)((byte)(s << 2 * (4 - k)));
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        char[] c = new char[this.length];
        for (int i2 = 0; i2 < this.length; ++i2) {
            c[i2] = this.getBase(i2);
        }
        sb.append(c);
        return sb.toString();
    }

    public String toStringHex() {
        int i2;
        StringBuilder sb = new StringBuilder();
        char[] c = new char[this.length];
        for (i2 = 0; i2 < this.length; ++i2) {
            c[i2] = this.getBase(i2);
        }
        sb.append(c);
        sb.append("\t");
        for (i2 = 0; i2 < this.codes.length; ++i2) {
            sb.append(Integer.toHexString(this.codes[i2]));
        }
        return sb.toString();
    }

    static {
        DnaSequenceByte.BASE2CODE[97] = 0;
        DnaSequenceByte.BASE2CODE[65] = 0;
        DnaSequenceByte.BASE2CODE[99] = 1;
        DnaSequenceByte.BASE2CODE[67] = 1;
        DnaSequenceByte.BASE2CODE[103] = 2;
        DnaSequenceByte.BASE2CODE[71] = 2;
        DnaSequenceByte.BASE2CODE[116] = 3;
        DnaSequenceByte.BASE2CODE[84] = 3;
    }
}

