/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.DnaSequence;
import org.snpeff.collections.OpenBitSet;

public class DnaNSequence
extends DnaSequence {
    private static final long serialVersionUID = 843945646419836582L;
    OpenBitSet hasN;
    private static DnaNSequence EMPTY = null;

    public static DnaNSequence empty() {
        if (EMPTY == null) {
            EMPTY = new DnaNSequence("");
        }
        return EMPTY;
    }

    public DnaNSequence(int length, long[] codes) {
        super(length, codes);
        this.hasN = new OpenBitSet(length);
    }

    public DnaNSequence(String seqStr) {
        super(null);
        if (seqStr == null) {
            this.hasN = new OpenBitSet();
        } else {
            this.set(seqStr);
        }
    }

    @Override
    protected DnaNSequence factory() {
        return new DnaNSequence(null);
    }

    @Override
    DnaSequence factory(int length, long[] codes) {
        return new DnaNSequence(length, codes);
    }

    @Override
    public char getBase(int index) {
        if (this.hasN.fastGet(index)) {
            return 'N';
        }
        return super.getBase(index);
    }

    @Override
    public String getBases(int index, int len) {
        char[] bases = new char[len];
        int j = index / this.coder.basesPerWord();
        int k = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
        int i2 = 0;
        int idx = index;
        while (i2 < len) {
            bases[i2] = this.hasN.fastGet(idx) ? 78 : this.coder.toBase(this.codes[j], k);
            if (--k < 0) {
                k = this.coder.lastBaseinWord();
                ++j;
            }
            ++i2;
            ++idx;
        }
        return new String(bases);
    }

    @Override
    public BinarySequence read(DataInputStream dataInStream) throws IOException {
        DnaNSequence binSeq = new DnaNSequence(null);
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        super.readDataStream(dataInStream);
        long[] bits = new long[OpenBitSet.bits2words(this.length)];
        for (int i2 = 0; i2 < bits.length; ++i2) {
            bits[i2] = dataInStream.readLong();
        }
        this.hasN = new OpenBitSet(bits, bits.length);
    }

    @Override
    public BinarySequence reverseWc() {
        DnaNSequence rwc = this.factory();
        rwc.codes = new long[this.codes.length];
        rwc.length = this.length;
        rwc.hasN.ensureCapacity(this.length);
        int j = 0;
        int k = 0;
        long s = 0L;
        int index = this.length - 1;
        int i2 = 0;
        while (index >= 0) {
            int idx = index / this.coder.basesPerWord();
            int off = this.coder.lastBaseinWord() - index % this.coder.basesPerWord();
            int c = this.coder.decodeWord(this.codes[idx], off);
            c = 3 & ~c;
            s <<= 2;
            s |= (long)c;
            if (++k >= this.coder.basesPerWord()) {
                rwc.codes[j] = s;
                k = 0;
                ++j;
                s = 0L;
            }
            if (this.hasN.get(index)) {
                rwc.hasN.set(i2);
            }
            --index;
            ++i2;
        }
        if (k < 64 && k != 0) {
            rwc.codes[j] = s <<= 64 - (k << 1);
        }
        return rwc;
    }

    @Override
    public void set(String seqStr) {
        super.set(seqStr, true);
        this.hasN = new OpenBitSet(seqStr.length());
        char[] seqChar = seqStr.toCharArray();
        block3: for (int i2 = 0; i2 < seqChar.length; ++i2) {
            switch (seqChar[i2]) {
                case 'A': 
                case 'C': 
                case 'G': 
                case 'T': 
                case 'U': 
                case 'a': 
                case 'c': 
                case 'g': 
                case 't': 
                case 'u': {
                    continue block3;
                }
                default: {
                    this.hasN.fastSet(i2);
                }
            }
        }
    }

    @Override
    public void setBase(int index, char base) {
        if (base == 'N' || base == 'n') {
            this.hasN.fastSet(index);
        } else {
            this.hasN.fastClear(index);
            super.setBase(index, base);
        }
    }

    @Override
    public String toString() {
        return this.getSequence();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        super.write(dataOutStream);
        long[] bits = this.hasN.getBits();
        for (int i2 = 0; i2 < bits.length; ++i2) {
            dataOutStream.writeLong(bits[i2]);
        }
    }
}

