/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.binseq;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.snpeff.binseq.BinarySequence;
import org.snpeff.binseq.coder.Coder;
import org.snpeff.binseq.coder.DnaCoder;
import org.snpeff.binseq.coder.DnaQualityCoder;
import org.snpeff.fastq.Fastq;
import org.snpeff.fastq.FastqVariant;

public class DnaAndQualitySequence
extends BinarySequence {
    private static final long serialVersionUID = 4523047567848438494L;
    private static DnaAndQualitySequence EMPTY = null;
    private static final DnaQualityCoder coder = DnaQualityCoder.get();
    byte[] codes;

    public static DnaAndQualitySequence empty() {
        if (EMPTY == null) {
            EMPTY = new DnaAndQualitySequence("");
        }
        return EMPTY;
    }

    public DnaAndQualitySequence(Fastq fastq) {
        this.set(fastq.getSequence(), fastq.getQuality(), fastq.getVariant());
    }

    public DnaAndQualitySequence(String seqStr) {
        if (seqStr != null) {
            this.set(seqStr);
        }
    }

    public DnaAndQualitySequence(String seqStr, String qualityStr, FastqVariant type) {
        this.set(seqStr, qualityStr, type);
    }

    @Override
    public int compareTo(BinarySequence o) {
        DnaAndQualitySequence bs = (DnaAndQualitySequence)o;
        int minlen = Math.min(this.length(), bs.length());
        for (int i2 = 0; i2 < minlen; ++i2) {
            int b1 = this.codes[i2] & 3;
            int b2 = bs.codes[i2] & 3;
            if (b1 < b2) {
                return -1;
            }
            if (b1 <= b2) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public char getBase(int index) {
        return DnaCoder.TO_BASE[this.codes[index] & 3];
    }

    @Override
    public int getCode(int index) {
        return this.codes[index] & (int)coder.mask(0);
    }

    @Override
    public Coder getCoder() {
        return coder;
    }

    public byte[] getCodes() {
        return this.codes;
    }

    public String getQuality() {
        StringBuilder sbq = new StringBuilder();
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            int q = coder.toQuality(this.codes[i2]);
            char qchar = (char)(33 + q);
            sbq.append(qchar);
        }
        return sbq.toString();
    }

    public int getQuality(int index) {
        return coder.toQuality(this.codes[index]);
    }

    @Override
    public String getSequence() {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            char c = coder.toBase(this.codes[i2]);
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        long hash = 0L;
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            hash = hash * 33L + (long)this.codes[i2];
        }
        return (int)hash;
    }

    public int indexOf(String seq) {
        return this.getSequence().indexOf(seq);
    }

    public int lastIndexOf(String seq) {
        return this.getSequence().lastIndexOf(seq);
    }

    @Override
    public int length() {
        return this.codes.length;
    }

    @Override
    public DnaAndQualitySequence overlap(BinarySequence sequence, int start) {
        DnaAndQualitySequence seq2;
        DnaAndQualitySequence seq1;
        DnaAndQualitySequence seq = (DnaAndQualitySequence)sequence;
        if (start >= 0) {
            seq1 = this;
            seq2 = seq;
        } else {
            seq1 = seq;
            seq2 = this;
            start = -start;
        }
        int len = Math.max(seq1.length(), start + seq2.length());
        byte[] newCodes = new byte[len];
        DnaAndQualitySequence newSeq = new DnaAndQualitySequence((String)null);
        newSeq.codes = newCodes;
        int i2 = 0;
        int j = -start;
        while (i2 < len) {
            if (j < 0) {
                newCodes[i2] = seq1.codes[i2];
            } else if (i2 >= seq1.length() && j < seq2.length()) {
                newCodes[i2] = seq2.codes[j];
            } else if (i2 < seq1.length() && j >= seq2.length()) {
                newCodes[i2] = seq1.codes[i2];
            } else {
                byte code1 = seq1.codes[i2];
                byte code2 = seq2.codes[j];
                if (coder.toBase(code1) == coder.toBase(code2)) {
                    q = coder.toQuality(code1) + coder.toQuality(code2);
                    newCodes[i2] = (byte)coder.replaceQuality(code1, q);
                } else {
                    q = 0;
                    int q1 = coder.toQuality(code1);
                    int q2 = coder.toQuality(code2);
                    char base = ' ';
                    if (q1 >= q2) {
                        q = q1;
                        base = coder.toBase(code1);
                    } else {
                        q = q2;
                        base = coder.toBase(code2);
                    }
                    newCodes[i2] = (byte)coder.baseToBits(base, q);
                }
            }
            ++i2;
            ++j;
        }
        return newSeq;
    }

    @Override
    public DnaAndQualitySequence read(DataInputStream dataInStream) throws IOException {
        DnaAndQualitySequence binSeq = new DnaAndQualitySequence((String)null);
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        int length = dataInStream.readInt();
        this.codes = new byte[length];
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            this.codes[i2] = dataInStream.readByte();
        }
    }

    @Override
    public DnaAndQualitySequence reverseWc() {
        DnaAndQualitySequence rwc = new DnaAndQualitySequence((String)null);
        rwc.codes = new byte[this.codes.length];
        int xorMask = 3;
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            rwc.codes[this.codes.length - i2 - 1] = (byte)(this.codes[i2] ^ xorMask);
        }
        return rwc;
    }

    @Override
    public void set(String seqStr) {
        int length = seqStr.length();
        this.codes = new byte[length];
        char[] seqChar = seqStr.toCharArray();
        for (int i2 = 0; i2 < length; ++i2) {
            this.codes[i2] = (byte)(coder.baseToBits(seqChar[i2]) & 0xFF);
        }
    }

    public void set(String seqStr, String qualityStr, FastqVariant type) {
        int length = seqStr.length();
        this.codes = new byte[length];
        char[] seqChar = seqStr.toCharArray();
        char[] qualChar = qualityStr.toCharArray();
        int qbase = 0;
        switch (type) {
            case FASTQ_SANGER: {
                qbase = 33;
                break;
            }
            case FASTQ_SOLEXA: {
                qbase = 64;
                break;
            }
            case FASTQ_ILLUMINA: {
                qbase = 64;
                break;
            }
            default: {
                throw new RuntimeException("Unsuported quality type: " + String.valueOf((Object)type));
            }
        }
        for (int i2 = 0; i2 < length; ++i2) {
            int q = Math.min(qualChar[i2] - qbase, 63);
            if (q < 0 && type != FastqVariant.FASTQ_SOLEXA) {
                throw new RuntimeException("Quality is below zero! Quality character: '" + qualChar[i2] + "', quality=" + q + ", type '" + String.valueOf((Object)type) + "'.");
            }
            this.codes[i2] = (byte)(coder.baseToBits(seqChar[i2]) | coder.qualityToBits(q));
        }
    }

    public String toString() {
        return this.getSequence() + "\t" + this.getQuality();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        dataOutStream.writeInt(this.codes.length);
        for (int i2 = 0; i2 < this.codes.length; ++i2) {
            dataOutStream.write(this.codes);
        }
    }
}

