/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.align;

import org.snpeff.align.NeedlemanWunsch;
import org.snpeff.interval.Variant;

public class VcfRefAltAlign
extends NeedlemanWunsch {
    public static final int MAX_SIZE = 10240;
    String stringA;
    String stringB;
    Variant.VariantType variantType;

    public VcfRefAltAlign(String a, String b) {
        super(a, b);
        this.stringA = a;
        this.stringB = b;
    }

    @Override
    public String align() {
        try {
            if (!this.simpleAlign()) {
                long size = (long)this.stringA.length() * (long)this.stringB.length();
                if (size > 0L && size < 10240L) {
                    this.scoreMatrix();
                    this.calcAlignment();
                    if (this.stringB.length() > this.stringA.length()) {
                        if (this.alignment.startsWith("-")) {
                            this.variantType = Variant.VariantType.DEL;
                            return this.alignment;
                        }
                    } else if (this.stringB.length() < this.stringA.length() && this.alignment.startsWith("+")) {
                        this.variantType = Variant.VariantType.INS;
                        return this.alignment;
                    }
                }
                this.substitution();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Error aligning sequences:\n\tSequence 1: " + new String(this.a) + "\n\tSequence 2: " + new String(this.b), t);
        }
        return this.alignment;
    }

    public Variant.VariantType getVariantType() {
        return this.variantType;
    }

    int minCommonBase() {
        int i2;
        int min = Math.min(this.stringA.length(), this.stringB.length());
        for (i2 = 0; i2 < min; ++i2) {
            if (this.stringA.charAt(i2) == this.stringB.charAt(i2)) continue;
            return i2;
        }
        return i2;
    }

    public void setVariantType(Variant.VariantType variantType) {
        this.variantType = variantType;
    }

    boolean simpleAlign() {
        if (this.stringA.length() == this.stringB.length()) {
            this.offset = 0;
            if (this.stringA.equals(this.stringB)) {
                this.variantType = Variant.VariantType.INTERVAL;
                return true;
            }
            if (this.stringA.length() == 1) {
                this.variantType = Variant.VariantType.SNP;
                return true;
            }
            this.offset = this.minCommonBase();
            this.variantType = Variant.VariantType.MNP;
            return true;
        }
        this.offset = this.minCommonBase();
        this.trimCommonBasesEnd();
        if (this.stringA.length() < this.stringB.length()) {
            if (this.stringB.startsWith(this.stringA)) {
                this.variantType = Variant.VariantType.DEL;
                this.offset = this.stringA.length();
                this.alignment = "-" + this.stringB.substring(this.stringA.length(), this.stringB.length());
                return true;
            }
            this.variantType = Variant.VariantType.MIXED;
            return true;
        }
        if (this.stringA.length() > this.stringB.length()) {
            if (this.stringA.startsWith(this.stringB)) {
                this.variantType = Variant.VariantType.INS;
                this.offset = this.stringB.length();
                this.alignment = "+" + this.stringA.substring(this.stringB.length(), this.stringA.length());
                return true;
            }
            this.variantType = Variant.VariantType.MIXED;
            return true;
        }
        return false;
    }

    void substitution() {
        this.variantType = Variant.VariantType.MIXED;
        int min = Math.min(this.stringA.length(), this.stringB.length());
        int i2 = 0;
        while (i2 < min && this.stringA.charAt(i2) == this.stringB.charAt(i2)) {
            this.offset = i2++;
        }
    }

    void trimCommonBasesEnd() {
        int ia = this.stringA.length() - 1;
        int ib = this.stringB.length() - 1;
        int count = 0;
        while (ia >= this.offset && ib >= this.offset && this.stringA.charAt(ia) == this.stringB.charAt(ib)) {
            --ia;
            --ib;
            ++count;
        }
        if (count > 0) {
            this.stringA = this.stringA.substring(0, ia + 1);
            this.stringB = this.stringB.substring(0, ib + 1);
        }
    }
}

