/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.align;

public class StringDiff {
    String s1;
    String s2;
    String name1;
    String name2;
    int count = -1;
    double error = -1.0;

    public StringDiff(String s1, String s2) {
        this.s1 = s1;
        this.s2 = s2;
    }

    public StringDiff(String s1, String name1, String s2, String name2) {
        this.s1 = s1;
        this.s2 = s2;
        this.name1 = name1;
        this.name2 = name2;
    }

    public int count() {
        if (this.count >= 0) {
            return this.count;
        }
        int minLen = this.minLen();
        this.count = 0;
        for (int j = 0; j < minLen; ++j) {
            if (this.s1.charAt(j) == this.s2.charAt(j)) continue;
            ++this.count;
        }
        return this.count;
    }

    public String diffString() {
        int minLen = this.minLen();
        char[] diff = new char[minLen];
        for (int j = 0; j < minLen; ++j) {
            diff[j] = this.s1.charAt(j) != this.s2.charAt(j) ? 124 : 32;
        }
        return new String(diff);
    }

    public double error() {
        int minLen = this.minLen();
        return minLen > 0 ? (double)this.count() / (double)minLen : 0.0;
    }

    int minLen() {
        return Math.min(this.s1.length(), this.s2.length());
    }

    public String toString() {
        String nameDiff = "diff";
        if (this.name1 != null && this.name2 != null) {
            int maxTitleLen = Math.max(Math.max(this.name1.length(), this.name2.length()), nameDiff.length());
            String format = "%" + maxTitleLen + "s : %s";
            format = format + "\n" + format + "\n" + format + "\n";
            return String.format(format, this.name1, this.s1, nameDiff, this.diffString(), this.name2, this.s2);
        }
        return String.format("%s\n%s\n%s\n", this.s1, this.diffString(), this.s2);
    }
}

