/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.align;

import org.snpeff.align.NeedlemanWunsch;

public class SmithWaterman
extends NeedlemanWunsch {
    public SmithWaterman(String a, String b) {
        super(a, b);
        this.useSpace = false;
    }

    @Override
    void calcAlignment() {
        int h;
        int i2;
        int maxLen = Math.max(this.a.length, this.b.length);
        this.alignmentA = new char[maxLen];
        this.alignmentB = new char[maxLen];
        for (i2 = 0; i2 < maxLen; ++i2) {
            this.alignmentB[i2] = 32;
            this.alignmentA[i2] = 32;
        }
        i2 = this.a.length;
        int j = this.b.length;
        int maxScore = 0;
        for (int ii = 0; ii <= this.a.length; ++ii) {
            for (int jj = 0; jj <= this.b.length; ++jj) {
                if (this.getScore(ii, jj) <= maxScore) continue;
                maxScore = this.getScore(ii, jj);
                i2 = ii;
                j = jj;
            }
        }
        for (h = Math.max(i2, j) - 1; i2 > 0 && j > 0 && h >= 0; --h) {
            int s = this.getScore(i2, j);
            int scorediag = this.getScore(i2 - 1, j - 1);
            int scoreup = this.getScore(i2, j - 1);
            int scoreleft = this.getScore(i2 - 1, j);
            if (s <= 0) break;
            if (s == scoreup + this.deletion) {
                this.alignmentA[h] = 45;
                this.alignmentB[h] = this.b[j - 1];
                --j;
                continue;
            }
            if (s == scoreleft + this.deletion) {
                this.alignmentA[h] = this.a[i2 - 1];
                this.alignmentB[h] = 45;
                --i2;
                continue;
            }
            if (s != scorediag + this.simmilarity(i2, j)) break;
            if (this.useSpace) {
                this.alignmentA[h] = 32;
                this.alignmentB[h] = 32;
            } else {
                this.alignmentA[h] = this.a[i2 - 1];
                this.alignmentB[h] = this.b[j - 1];
            }
            --i2;
            --j;
        }
        while (i2 > 0 && h >= 0) {
            this.alignmentA[h] = this.a[i2 - 1];
            this.alignmentB[h] = 45;
            --i2;
            --h;
        }
        while (j > 0 && h >= 0) {
            this.alignmentA[h] = 45;
            this.alignmentB[h] = this.b[j - 1];
            --j;
            --h;
        }
        this.offset = 0;
        while (this.offset < maxLen && this.alignmentA[this.offset] == ' ') {
            ++this.offset;
        }
        StringBuffer alsb = new StringBuffer();
        int prev = 32;
        for (i2 = 0; i2 < maxLen; ++i2) {
            if (this.alignmentA[i2] == '-') {
                if (prev != 45) {
                    alsb.append('-');
                }
                alsb.append(this.alignmentB[i2]);
                prev = 45;
                continue;
            }
            if (this.alignmentB[i2] != '-') continue;
            if (prev != 43) {
                alsb.append('+');
            }
            alsb.append(this.alignmentA[i2]);
            prev = 43;
        }
        this.alignment = alsb.toString();
    }

    @Override
    void scoreMatrix() {
        int i2;
        this.score = new int[this.a.length + 1][this.b.length + 1];
        for (i2 = 0; i2 <= this.a.length; ++i2) {
            this.setScore(i2, 0, 0);
        }
        for (int j = 0; j <= this.b.length; ++j) {
            this.setScore(0, j, 0);
        }
        this.bestScore = Integer.MIN_VALUE;
        for (i2 = 1; i2 <= this.a.length; ++i2) {
            for (int j = 1; j <= this.b.length; ++j) {
                int match = this.getScore(i2 - 1, j - 1) + this.simmilarity(i2, j);
                int del = this.getScore(i2 - 1, j) + this.deletion;
                int ins = this.getScore(i2, j - 1) + this.deletion;
                int s = Math.max(0, Math.max(match, Math.max(del, ins)));
                this.setScore(i2, j, s);
                this.bestScore = Math.max(this.bestScore, s);
            }
        }
    }
}

