/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.align.util.AtomCache;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.biojava.nbio.structure.secstruc.SecStrucInfo;
import org.snpeff.util.Log;

public class Zzz {
    String fileName;
    Structure structure;

    public Zzz(String fileName) {
        this.fileName = fileName;
    }

    public static void main(String[] args) throws Exception {
        Log.info("Start");
        Zzz zzz = new Zzz("tests/integration/zzz/pdb/pdb5pti.ent.gz");
        zzz.load();
        zzz.show();
        Log.info("End");
    }

    public Structure load() throws IOException {
        Log.info("Reading PDB file: " + this.fileName);
        File file = new File(this.fileName);
        System.setProperty("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true");
        System.setProperty("PDB_DIR", file.getParent());
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(file);
        FileParsingParameters params = new FileParsingParameters();
        params.setParseSecStruc(true);
        AtomCache cache = new AtomCache();
        cache.setFileParsingParams(params);
        PDBFileParser pdbpars = new PDBFileParser();
        pdbpars.setFileParsingParameters(params);
        this.structure = pdbpars.parsePDBFile(inStream);
        inStream.close();
        return this.structure;
    }

    public void show() {
        for (Chain c : this.structure.getChains()) {
            for (Group g : c.getAtomGroups()) {
                if (!g.hasAminoAtoms()) continue;
                SecStrucInfo ss = (SecStrucInfo)g.getProperty("secstruc");
                System.out.println(c.getId() + " " + String.valueOf(g.getResidueNumber()) + " " + g.getPDBName() + " -> " + String.valueOf(ss));
            }
        }
    }
}

