/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.snpeff.fileIterator.RegulationFileIterator;
import org.snpeff.interval.Regulation;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.util.Timer;

public class RegulationFileSplitBytType {
    static final int BLOCK_SIZE = 1000000;
    boolean verbose = false;
    String path;
    Set<String> regTypes = new HashSet<String>();
    Set<String> regFileNames = new HashSet<String>();
    Map<String, StringBuilder> lineByRegType;

    void add(String regType, String line) {
        StringBuilder sb = this.lineByRegType.get(regType);
        if (sb == null) {
            sb = new StringBuilder();
            this.lineByRegType.put(regType, sb);
        }
        sb.append(line + "\n");
        this.regTypes.add(regType);
    }

    public Set<String> getRegFileNames() {
        return this.regFileNames;
    }

    public Collection<String> getRegTypes() {
        return this.regTypes;
    }

    String outputFileName(String regType) {
        String rType = Gpr.sanityzeFileName(regType);
        return this.path + "/regulation_" + rType + ".gff";
    }

    boolean readBlock(RegulationFileIterator regulationFileIterator) {
        if (this.verbose) {
            Timer.show("\tReading block of lines starting at line " + regulationFileIterator.getLineNum());
        }
        this.lineByRegType = new HashMap<String, StringBuilder>();
        for (int i2 = 0; i2 < 1000000; ++i2) {
            if (!regulationFileIterator.hasNext()) {
                return false;
            }
            Regulation reg = (Regulation)regulationFileIterator.next();
            this.add(reg.getRegulationType(), regulationFileIterator.getLine());
        }
        return true;
    }

    void saveBlock() {
        if (this.verbose) {
            Timer.show("\tSaving block of lines");
        }
        for (String regType : this.lineByRegType.keySet()) {
            String fileName = this.outputFileName(regType);
            if (this.verbose) {
                String createAppend = Gpr.exists(fileName) ? "Appending" : "Creating";
                Log.info("\t\t" + createAppend + " file '" + fileName + "'");
            }
            Gpr.toFile(fileName, this.lineByRegType.get(regType), true);
            this.regFileNames.add(fileName);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void splitFile(RegulationFileIterator regulationFileIterator, String path) {
        this.path = path;
        while (this.readBlock(regulationFileIterator)) {
            this.saveBlock();
        }
        this.saveBlock();
    }
}

