/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.snpeff.RegulationFileConsensus;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.RegulationBedFileIterator;
import org.snpeff.interval.Regulation;
import org.snpeff.util.Log;

public class RegulationConsensusMultipleBed {
    boolean verbose = false;
    AutoHashMap<String, ArrayList<String>> filesByCellType;
    HashMap<String, String> epiMarkByFile;
    String outDir;
    String inDir;
    String cellType = null;

    public RegulationConsensusMultipleBed(String inDir, String outDir) {
        this.inDir = inDir;
        this.outDir = outDir;
    }

    RegulationFileConsensus consensus(RegulationFileConsensus regCons, String cellType) {
        if (this.verbose) {
            Log.info("Creating consensus for cell type: " + cellType);
        }
        ArrayList<Regulation> regs = regCons.getRegulationList(cellType);
        if (this.verbose) {
            Log.info("Sorting: " + cellType + "\t, size: " + regs.size());
        }
        Collections.sort(regs);
        if (this.verbose) {
            Log.info("Adding to final consensus");
        }
        RegulationFileConsensus consCellType = new RegulationFileConsensus();
        regCons.setVerbose(this.verbose);
        for (Regulation reg : regs) {
            consCellType.consensus(reg);
        }
        regs = consCellType.getRegulationList(cellType);
        if (this.verbose) {
            Log.info("Final consensus for cell type: " + cellType + "\t, size: " + regs.size());
        }
        return consCellType;
    }

    void consensusByRegType() {
        for (String cellType : this.filesByCellType.keySet()) {
            ArrayList<String> bedFiles = this.filesByCellType.getOrCreate(cellType);
            if (this.verbose) {
                Log.info("Creating consensus for cellType '" + cellType + "', files: " + String.valueOf(bedFiles));
            }
            RegulationFileConsensus regCons = this.readBeds(bedFiles, cellType);
            regCons.setOutputDir(this.outDir);
            regCons = this.consensus(regCons, cellType);
            regCons.save();
        }
    }

    RegulationFileConsensus readBeds(List<String> bedFiles, String cellType) {
        RegulationFileConsensus regCons = new RegulationFileConsensus();
        regCons.setVerbose(this.verbose);
        for (String bedFile : bedFiles) {
            if (this.verbose) {
                Log.info("Reading file '" + bedFile + "'");
            }
            String epigeneticMark = this.epiMarkByFile.get(bedFile);
            RegulationBedFileIterator regFile = new RegulationBedFileIterator(bedFile, epigeneticMark, cellType);
            regCons.readFile(regFile);
        }
        return regCons;
    }

    void readDir(String dirName) {
        this.filesByCellType = new AutoHashMap(new ArrayList());
        this.epiMarkByFile = new HashMap();
        int countFiles = 0;
        File dir = new File(dirName);
        for (String file : dir.list()) {
            String[] parts;
            if (file.indexOf(".bed") <= 0 || (parts = file.split("\\.")).length <= 2) continue;
            String cellType = parts[1];
            String epigeneticMark = parts[2];
            if (this.cellType != null && !this.cellType.equals(cellType)) continue;
            String filePath = dirName + "/" + file;
            this.epiMarkByFile.put(filePath, epigeneticMark);
            ArrayList<String> files = this.filesByCellType.getOrCreate(cellType);
            files.add(filePath);
            ++countFiles;
        }
        if (this.verbose) {
            Log.info("Directory has " + countFiles + " bed files and " + this.filesByCellType.size() + " cell types");
        }
    }

    public void run() {
        this.readDir(this.inDir);
        this.consensusByRegType();
        if (this.verbose) {
            Log.info("Done");
        }
    }

    public void setCellType(String cellType) {
        this.cellType = cellType;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

