/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class PromoterSequences {
    public static String HOME = System.getProperty("user.home");
    public static int LEN_UPSTREAM = 3000;
    public static int LEN_AFTER_TSS = 200;
    SnpEffectPredictor snpEffectPredictor;
    Config config;
    Genome genome;
    HashSet<String> geneIds;
    HashSet<Gene> genes;
    String fastaFile;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: " + PromoterSequences.class.getSimpleName() + " genomeName fastaFile.fa geneId_1 geneId_2 ... geneId_N");
            System.exit(1);
        }
        String genomeName = args[0];
        String fastaFile = args[1];
        ArrayList<String> geneIds = new ArrayList<String>();
        for (int i2 = 2; i2 < args.length; ++i2) {
            geneIds.add(args[i2]);
        }
        PromoterSequences promoterSequences = new PromoterSequences(genomeName, fastaFile, geneIds);
        promoterSequences.run();
    }

    public PromoterSequences(String genomeName, String fastaFile, List<String> geneIds) {
        this.fastaFile = fastaFile;
        this.geneIds = new HashSet();
        this.geneIds.addAll(geneIds);
        this.genes = new HashSet();
        Log.info("Loading database");
        String configFile = HOME + "/snpEff/snpEff.config";
        this.config = new Config(genomeName, configFile);
        this.config.loadSnpEffectPredictor();
        this.snpEffectPredictor = this.config.getSnpEffectPredictor();
        this.genome = this.snpEffectPredictor.getGenome();
    }

    public void run() {
        Log.info("Finding genes ");
        for (Gene gene : this.genome.getGenes()) {
            if (!this.geneIds.contains(gene.getId())) continue;
            System.err.println("\t" + gene.getId());
            this.genes.add(gene);
            this.geneIds.remove(gene.getId());
        }
        if (!this.geneIds.isEmpty()) {
            Log.info("Not found: " + String.valueOf(this.geneIds));
        }
        Log.info("Reading fasta file: " + this.fastaFile);
        HashSet<Gene> done = new HashSet<Gene>();
        FastaFileIterator ffi = new FastaFileIterator(this.fastaFile);
        block1: for (String seq : ffi) {
            String chrName = ffi.getName();
            Log.info("Read: " + chrName);
            for (Gene gene : this.genes) {
                if (gene.getChromosomeName().equals(chrName)) {
                    int start = 0;
                    int end = 0;
                    if (gene.isStrandPlus()) {
                        start = gene.getStart() - LEN_UPSTREAM;
                        end = gene.getStart() + LEN_AFTER_TSS;
                    } else {
                        start = gene.getEnd() - LEN_AFTER_TSS;
                        end = gene.getEnd() + LEN_UPSTREAM;
                    }
                    String subSeq = seq.substring(start, end + 1);
                    System.out.println(GprSeq.string2fasta(gene.getId(), subSeq));
                    done.add(gene);
                }
                if (!done.containsAll(this.genes)) continue;
                continue block1;
            }
        }
        ffi.close();
        Log.info("Done");
    }
}

