/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.EngineDiscoveryOrchestrator;
import org.junit.platform.launcher.core.EngineExecutionOrchestrator;
import org.junit.platform.launcher.core.InternalLauncher;
import org.junit.platform.launcher.core.InternalTestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ListenerRegistry;

class DefaultLauncher
implements InternalLauncher {
    private final ListenerRegistry<LauncherDiscoveryListener> launcherDiscoveryListenerRegistry = ListenerRegistry.forLauncherDiscoveryListeners();
    private final ListenerRegistry<TestExecutionListener> testExecutionListenerRegistry = ListenerRegistry.forTestExecutionListeners();
    private final EngineExecutionOrchestrator executionOrchestrator = new EngineExecutionOrchestrator(this.testExecutionListenerRegistry);
    private final EngineDiscoveryOrchestrator discoveryOrchestrator;

    DefaultLauncher(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        Preconditions.condition(testEngines != null && testEngines.iterator().hasNext(), () -> "Cannot create Launcher without at least one TestEngine; consider adding an engine implementation JAR to the classpath");
        Preconditions.notNull(postDiscoveryFilters, "PostDiscoveryFilter array must not be null");
        Preconditions.containsNoNullElements(postDiscoveryFilters, "PostDiscoveryFilter array must not contain null elements");
        this.discoveryOrchestrator = new EngineDiscoveryOrchestrator(testEngines, Collections.unmodifiableCollection(postDiscoveryFilters), this.launcherDiscoveryListenerRegistry);
    }

    @Override
    public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
        this.launcherDiscoveryListenerRegistry.addAll((LauncherDiscoveryListener[])listeners);
    }

    @Override
    public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
        this.testExecutionListenerRegistry.addAll((TestExecutionListener[])listeners);
    }

    @Override
    public TestPlan discover(LauncherDiscoveryRequest discoveryRequest) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        return InternalTestPlan.from(this.discover(discoveryRequest, EngineDiscoveryOrchestrator.Phase.DISCOVERY));
    }

    @Override
    public void execute(LauncherDiscoveryRequest discoveryRequest, TestExecutionListener ... listeners) {
        Preconditions.notNull(discoveryRequest, "LauncherDiscoveryRequest must not be null");
        Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.execute(InternalTestPlan.from(this.discover(discoveryRequest, EngineDiscoveryOrchestrator.Phase.EXECUTION)), listeners);
    }

    @Override
    public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
        Preconditions.notNull(testPlan, "TestPlan must not be null");
        Preconditions.condition(testPlan instanceof InternalTestPlan, "TestPlan was not returned by this Launcher");
        Preconditions.notNull(listeners, "TestExecutionListener array must not be null");
        Preconditions.containsNoNullElements(listeners, "individual listeners must not be null");
        this.execute((InternalTestPlan)testPlan, listeners);
    }

    @Override
    public ListenerRegistry<TestExecutionListener> getTestExecutionListenerRegistry() {
        return this.testExecutionListenerRegistry;
    }

    @Override
    public ListenerRegistry<LauncherDiscoveryListener> getLauncherDiscoveryListenerRegistry() {
        return this.launcherDiscoveryListenerRegistry;
    }

    private LauncherDiscoveryResult discover(LauncherDiscoveryRequest discoveryRequest, EngineDiscoveryOrchestrator.Phase phase) {
        return this.discoveryOrchestrator.discover(discoveryRequest, phase);
    }

    private void execute(InternalTestPlan internalTestPlan, TestExecutionListener[] listeners) {
        this.executionOrchestrator.execute(internalTestPlan, listeners);
    }
}

