/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.parser;

import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.Node;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.ParserTreeConstants;
import org.apache.commons.jexl2.parser.ParserVisitor;

public class SimpleNode
implements Node {
    protected JexlNode parent;
    protected JexlNode[] children;
    protected final int id;
    protected volatile Object value;

    public SimpleNode(int i2) {
        this.id = i2;
    }

    public SimpleNode(Parser p, int i2) {
        this(i2);
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node n) {
        this.parent = (JexlNode)n;
    }

    public JexlNode jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node n, int i2) {
        if (this.children == null) {
            this.children = new JexlNode[i2 + 1];
        } else if (i2 >= this.children.length) {
            JexlNode[] c = new JexlNode[i2 + 1];
            System.arraycopy(this.children, 0, c, 0, this.children.length);
            this.children = c;
        }
        this.children[i2] = (JexlNode)n;
    }

    public JexlNode jjtGetChild(int i2) {
        return this.children[i2];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public void jjtSetValue(Object value) {
        this.value = value;
    }

    public Object jjtGetValue() {
        return this.value;
    }

    public Object jjtAccept(ParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object childrenAccept(ParserVisitor visitor, Object data) {
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                this.children[i2].jjtAccept(visitor, data);
            }
        }
        return data;
    }

    public String toString() {
        return ParserTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String prefix) {
        return prefix + this.toString();
    }

    public void dump(String prefix) {
        System.out.println(this.toString(prefix));
        if (this.children != null) {
            for (int i2 = 0; i2 < this.children.length; ++i2) {
                JexlNode n = this.children[i2];
                if (n == null) continue;
                n.dump(prefix + " ");
            }
        }
    }
}

