/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.NamespaceResolver;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.JexlPropertyGet;
import org.apache.commons.jexl2.introspection.JexlPropertySet;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.parser.ASTAdditiveNode;
import org.apache.commons.jexl2.parser.ASTAdditiveOperator;
import org.apache.commons.jexl2.parser.ASTAmbiguous;
import org.apache.commons.jexl2.parser.ASTAndNode;
import org.apache.commons.jexl2.parser.ASTArrayAccess;
import org.apache.commons.jexl2.parser.ASTArrayLiteral;
import org.apache.commons.jexl2.parser.ASTAssignment;
import org.apache.commons.jexl2.parser.ASTBitwiseAndNode;
import org.apache.commons.jexl2.parser.ASTBitwiseComplNode;
import org.apache.commons.jexl2.parser.ASTBitwiseOrNode;
import org.apache.commons.jexl2.parser.ASTBitwiseXorNode;
import org.apache.commons.jexl2.parser.ASTBlock;
import org.apache.commons.jexl2.parser.ASTConstructorNode;
import org.apache.commons.jexl2.parser.ASTDivNode;
import org.apache.commons.jexl2.parser.ASTEQNode;
import org.apache.commons.jexl2.parser.ASTERNode;
import org.apache.commons.jexl2.parser.ASTEmptyFunction;
import org.apache.commons.jexl2.parser.ASTFalseNode;
import org.apache.commons.jexl2.parser.ASTFloatLiteral;
import org.apache.commons.jexl2.parser.ASTForeachStatement;
import org.apache.commons.jexl2.parser.ASTFunctionNode;
import org.apache.commons.jexl2.parser.ASTGENode;
import org.apache.commons.jexl2.parser.ASTGTNode;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTIfStatement;
import org.apache.commons.jexl2.parser.ASTIntegerLiteral;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTLENode;
import org.apache.commons.jexl2.parser.ASTLTNode;
import org.apache.commons.jexl2.parser.ASTMapEntry;
import org.apache.commons.jexl2.parser.ASTMapLiteral;
import org.apache.commons.jexl2.parser.ASTMethodNode;
import org.apache.commons.jexl2.parser.ASTModNode;
import org.apache.commons.jexl2.parser.ASTMulNode;
import org.apache.commons.jexl2.parser.ASTNENode;
import org.apache.commons.jexl2.parser.ASTNRNode;
import org.apache.commons.jexl2.parser.ASTNotNode;
import org.apache.commons.jexl2.parser.ASTNullLiteral;
import org.apache.commons.jexl2.parser.ASTNumberLiteral;
import org.apache.commons.jexl2.parser.ASTOrNode;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.ASTReferenceExpression;
import org.apache.commons.jexl2.parser.ASTReturnStatement;
import org.apache.commons.jexl2.parser.ASTSizeFunction;
import org.apache.commons.jexl2.parser.ASTSizeMethod;
import org.apache.commons.jexl2.parser.ASTStringLiteral;
import org.apache.commons.jexl2.parser.ASTTernaryNode;
import org.apache.commons.jexl2.parser.ASTTrueNode;
import org.apache.commons.jexl2.parser.ASTUnaryMinusNode;
import org.apache.commons.jexl2.parser.ASTVar;
import org.apache.commons.jexl2.parser.ASTWhileStatement;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.ParserVisitor;
import org.apache.commons.jexl2.parser.SimpleNode;
import org.apache.commons.logging.Log;

public class Interpreter
implements ParserVisitor {
    protected final Log logger;
    protected final Uberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final Map<String, Object> functions;
    protected Map<String, Object> functors;
    protected final JexlContext context;
    protected boolean strict;
    protected boolean silent;
    protected final boolean cache;
    protected Object[] registers = null;
    private String[] parameters = null;
    private volatile boolean cancelled = false;
    protected static final Object[] EMPTY_PARAMS = new Object[0];

    @Deprecated
    public Interpreter(JexlEngine jexl, JexlContext aContext) {
        this(jexl, aContext, !jexl.isLenient(), jexl.isSilent());
    }

    public Interpreter(JexlEngine jexl, JexlContext aContext, boolean strictFlag, boolean silentFlag) {
        this.logger = jexl.logger;
        this.uberspect = jexl.uberspect;
        this.arithmetic = jexl.arithmetic;
        this.functions = jexl.functions;
        this.strict = strictFlag;
        this.silent = silentFlag;
        this.cache = jexl.cache != null;
        this.context = aContext != null ? aContext : JexlEngine.EMPTY_CONTEXT;
        this.functors = null;
    }

    protected Interpreter(Interpreter base) {
        this.logger = base.logger;
        this.uberspect = base.uberspect;
        this.arithmetic = base.arithmetic;
        this.functions = base.functions;
        this.strict = base.strict;
        this.silent = base.silent;
        this.cache = base.cache;
        this.context = base.context;
        this.functors = base.functors;
    }

    @Deprecated
    public void setStrict(boolean flag) {
        this.strict = flag;
    }

    @Deprecated
    public void setSilent(boolean flag) {
        this.silent = flag;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public Object interpret(JexlNode node) {
        try {
            Object object = node.jjtAccept(this, null);
            return object;
        }
        catch (JexlException.Return xreturn) {
            Object value;
            Object object = value = xreturn.getValue();
            return object;
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                Object var3_6 = null;
                return var3_6;
            }
            throw xjexl;
        }
        finally {
            this.functors = null;
            this.parameters = null;
            this.registers = null;
        }
    }

    protected JexlContext getContext() {
        return this.context;
    }

    protected Uberspect getUberspect() {
        return this.uberspect;
    }

    @Deprecated
    protected void setRegisters(Object ... theRegisters) {
        if (theRegisters != null) {
            String[] regStrs = new String[theRegisters.length];
            for (int r = 0; r < regStrs.length; ++r) {
                regStrs[r] = "#" + r;
            }
            this.parameters = regStrs;
        }
        this.registers = theRegisters;
    }

    protected void setFrame(JexlEngine.Frame frame) {
        if (frame != null) {
            this.parameters = frame.getParameters();
            this.registers = frame.getRegisters();
        } else {
            this.parameters = null;
            this.registers = null;
        }
    }

    protected JexlNode findNullOperand(RuntimeException xrt, JexlNode node, Object left, Object right) {
        if (xrt instanceof ArithmeticException && "jexl.null" == xrt.getMessage()) {
            if (left == null) {
                return node.jjtGetChild(0);
            }
            if (right == null) {
                return node.jjtGetChild(1);
            }
        }
        return node;
    }

    protected Object unknownVariable(JexlException xjexl) {
        if (this.strict) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage());
        }
        return null;
    }

    protected Object invocationFailed(JexlException xjexl) {
        if (this.strict || xjexl instanceof JexlException.Return) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage(), xjexl.getCause());
        }
        return null;
    }

    protected boolean isCancelled() {
        if (this.cancelled | Thread.interrupted()) {
            this.cancelled = true;
        }
        return this.cancelled;
    }

    protected Object resolveNamespace(String prefix, JexlNode node) {
        Object[] args;
        JexlMethod ctor;
        Object namespace = null;
        if (this.functors != null && (namespace = this.functors.get(prefix)) != null) {
            return namespace;
        }
        if (this.context instanceof NamespaceResolver) {
            namespace = ((NamespaceResolver)((Object)this.context)).resolveNamespace(prefix);
        }
        if (namespace == null) {
            namespace = this.functions.get(prefix);
            if (prefix != null && namespace == null) {
                throw new JexlException(node, "no such function namespace " + prefix);
            }
        }
        if (namespace instanceof Class && (ctor = this.uberspect.getConstructorMethod(namespace, args = new Object[]{this.context}, node)) != null) {
            try {
                namespace = ctor.invoke(namespace, args);
                if (this.functors == null) {
                    this.functors = new HashMap<String, Object>();
                }
                this.functors.put(prefix, namespace);
            }
            catch (Exception xinst) {
                throw new JexlException(node, "unable to instantiate namespace " + prefix, (Throwable)xinst);
            }
        }
        return namespace;
    }

    public Object visit(ASTAdditiveNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        int size = node.jjtGetNumChildren();
        for (int c = 2; c < size; c += 2) {
            Object right = node.jjtGetChild(c).jjtAccept(this, data);
            try {
                JexlNode op = node.jjtGetChild(c - 1);
                if (op instanceof ASTAdditiveOperator) {
                    String which = op.image;
                    if ("+".equals(which)) {
                        left = this.arithmetic.add(left, right);
                        continue;
                    }
                    if ("-".equals(which)) {
                        left = this.arithmetic.subtract(left, right);
                        continue;
                    }
                    throw new UnsupportedOperationException("unknown operator " + which);
                }
                throw new IllegalArgumentException("unknown operator " + op);
            }
            catch (ArithmeticException xrt) {
                JexlNode xnode = this.findNullOperand(xrt, node, left, right);
                throw new JexlException(xnode, "+/- error", (Throwable)xrt);
            }
        }
        return left;
    }

    public Object visit(ASTAdditiveOperator node, Object data) {
        throw new UnsupportedOperationException("Shoud not be called.");
    }

    public Object visit(ASTAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (!leftValue) {
                return Boolean.FALSE;
            }
        }
        catch (RuntimeException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (!rightValue) {
                return Boolean.FALSE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTArrayAccess node, Object data) {
        Object object = node.jjtGetChild(0).jjtAccept(this, data);
        int numChildren = node.jjtGetNumChildren();
        for (int i2 = 1; i2 < numChildren; ++i2) {
            JexlNode nindex = node.jjtGetChild(i2);
            if (nindex instanceof JexlNode.Literal) {
                object = nindex.jjtAccept(this, object);
                continue;
            }
            Object index = nindex.jjtAccept(this, null);
            object = this.getAttribute(object, index, nindex);
        }
        return object;
    }

    public Object visit(ASTArrayLiteral node, Object data) {
        Object literal = node.getLiteral();
        if (literal == null) {
            int childCount = node.jjtGetNumChildren();
            Object[] array = new Object[childCount];
            for (int i2 = 0; i2 < childCount; ++i2) {
                Object entry;
                array[i2] = entry = node.jjtGetChild(i2).jjtAccept(this, data);
            }
            literal = this.arithmetic.narrowArrayType(array);
            node.setLiteral(literal);
        }
        return literal;
    }

    public Object visit(ASTAssignment node, Object data) {
        int c;
        int register = -1;
        JexlNode left = node.jjtGetChild(0);
        if (left instanceof ASTIdentifier) {
            ASTIdentifier var = (ASTIdentifier)left;
            register = var.getRegister();
            if (register < 0) {
                throw new JexlException(left, "unknown variable " + left.image);
            }
        } else if (!(left instanceof ASTReference)) {
            throw new JexlException(left, "illegal assignment form 0");
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        JexlNode objectNode = null;
        Object object = register >= 0 ? this.registers[register] : null;
        JexlNode propertyNode = null;
        Object property = null;
        boolean isVariable = true;
        int v = 0;
        StringBuilder variableName = null;
        int last = left.jjtGetNumChildren() - 1;
        boolean isRegister = last < 0 && register >= 0;
        int n = c = register >= 0 ? 1 : 0;
        while (c < last) {
            objectNode = left.jjtGetChild(c);
            object = objectNode.jjtAccept(this, object);
            if (object == null) {
                if (isVariable &= objectNode instanceof ASTIdentifier || objectNode instanceof ASTNumberLiteral && ((ASTNumberLiteral)objectNode).isInteger()) {
                    if (v == 0) {
                        variableName = new StringBuilder(left.jjtGetChild((int)0).image);
                        v = 1;
                    }
                    while (v <= c) {
                        variableName.append('.');
                        variableName.append(left.jjtGetChild((int)v).image);
                        ++v;
                    }
                    object = this.context.get(variableName.toString());
                    if (object != null) {
                        isVariable = false;
                    }
                } else {
                    throw new JexlException(objectNode, "illegal assignment form");
                }
            }
            ++c;
        }
        propertyNode = isRegister ? null : left.jjtGetChild(last);
        boolean antVar = false;
        if (propertyNode instanceof ASTIdentifier) {
            ASTIdentifier identifier = (ASTIdentifier)propertyNode;
            register = identifier.getRegister();
            if (register >= 0) {
                isRegister = true;
            } else {
                property = identifier.image;
                antVar = true;
            }
        } else if (propertyNode instanceof ASTNumberLiteral && ((ASTNumberLiteral)propertyNode).isInteger()) {
            property = ((ASTNumberLiteral)propertyNode).getLiteral();
            antVar = true;
        } else if (propertyNode instanceof ASTArrayAccess) {
            objectNode = propertyNode;
            ASTArrayAccess narray = (ASTArrayAccess)objectNode;
            Object nobject = narray.jjtGetChild(0).jjtAccept(this, object);
            if (nobject == null) {
                throw new JexlException(objectNode, "array element is null");
            }
            object = nobject;
            last = narray.jjtGetNumChildren() - 1;
            for (int i2 = 1; i2 < last; ++i2) {
                objectNode = narray.jjtGetChild(i2);
                if (objectNode instanceof JexlNode.Literal) {
                    object = objectNode.jjtAccept(this, object);
                    continue;
                }
                Object index = objectNode.jjtAccept(this, null);
                object = this.getAttribute(object, index, objectNode);
            }
            property = narray.jjtGetChild(last).jjtAccept(this, null);
        } else if (!isRegister) {
            throw new JexlException(objectNode, "illegal assignment form");
        }
        if (isRegister) {
            this.registers[register] = right;
            return right;
        }
        if (antVar && isVariable && object == null) {
            if (variableName != null) {
                if (last > 0) {
                    variableName.append('.');
                }
                variableName.append(property);
                property = variableName.toString();
            }
            try {
                this.context.set(String.valueOf(property), right);
            }
            catch (UnsupportedOperationException xsupport) {
                throw new JexlException(node, "context is readonly", (Throwable)xsupport);
            }
            return right;
        }
        if (property == null) {
            throw new JexlException(propertyNode, "property is null");
        }
        if (object == null) {
            throw new JexlException(objectNode, "bean is null");
        }
        this.setAttribute(object, property, right, propertyNode);
        return right;
    }

    public Object visit(ASTBitwiseAndNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.bitwiseAnd(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "& error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseComplNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            return this.arithmetic.bitwiseComplement(left);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "~ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.bitwiseOr(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "| error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBitwiseXorNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.bitwiseXor(left, right);
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "^ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTBlock node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i2 = 0; i2 < numChildren; ++i2) {
            result = node.jjtGetChild(i2).jjtAccept(this, data);
        }
        return result;
    }

    public Object visit(ASTDivNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.divide(left, right);
        }
        catch (ArithmeticException xrt) {
            if (!this.strict) {
                return new Double(0.0);
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "divide error", (Throwable)xrt);
        }
    }

    public Object visit(ASTEmptyFunction node, Object data) {
        Object o = node.jjtGetChild(0).jjtAccept(this, data);
        if (o == null) {
            return Boolean.TRUE;
        }
        if (o instanceof String && "".equals(o)) {
            return Boolean.TRUE;
        }
        if (o.getClass().isArray() && ((Object[])o).length == 0) {
            return Boolean.TRUE;
        }
        if (o instanceof Collection) {
            return ((Collection)o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (o instanceof Map) {
            return ((Map)o).isEmpty() ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTEQNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "== error", (Throwable)xrt);
        }
    }

    public Object visit(ASTFalseNode node, Object data) {
        return Boolean.FALSE;
    }

    public Object visit(ASTForeachStatement node, Object data) {
        Object result = null;
        ASTReference loopReference = (ASTReference)node.jjtGetChild(0);
        ASTIdentifier loopVariable = (ASTIdentifier)loopReference.jjtGetChild(0);
        int register = loopVariable.getRegister();
        Object iterableValue = node.jjtGetChild(1).jjtAccept(this, data);
        if (iterableValue != null && node.jjtGetNumChildren() >= 3) {
            JexlNode statement = node.jjtGetChild(2);
            Iterator<?> itemsIterator = this.uberspect.getIterator(iterableValue, node);
            if (itemsIterator != null) {
                while (itemsIterator.hasNext()) {
                    if (this.isCancelled()) {
                        throw new JexlException.Cancel(node);
                    }
                    Object value = itemsIterator.next();
                    if (register < 0) {
                        this.context.set(loopVariable.image, value);
                    } else {
                        this.registers[register] = value;
                    }
                    result = statement.jjtAccept(this, data);
                }
            }
        }
        return result;
    }

    public Object visit(ASTGENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.greaterThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, ">= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTGTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.greaterThan(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "> error", (Throwable)xrt);
        }
    }

    public Object visit(ASTERNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            if (right instanceof Pattern || right instanceof String) {
                return this.arithmetic.matches(left, right) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (right instanceof Set) {
                return ((Set)right).contains(left) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (right instanceof Map) {
                return ((Map)right).containsKey(left) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (right instanceof Collection) {
                return ((Collection)right).contains(left) ? Boolean.TRUE : Boolean.FALSE;
            }
            try {
                Object[] argv = new Object[]{left};
                JexlMethod vm = this.uberspect.getMethod(right, "contains", argv, node);
                if (vm != null) {
                    return this.arithmetic.toBoolean(vm.invoke(right, argv)) ? Boolean.TRUE : Boolean.FALSE;
                }
                if (this.arithmetic.narrowArguments(argv) && (vm = this.uberspect.getMethod(right, "contains", argv, node)) != null) {
                    return this.arithmetic.toBoolean(vm.invoke(right, argv)) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            catch (InvocationTargetException e) {
                throw new JexlException(node, "=~ invocation error", e.getCause());
            }
            catch (Exception e) {
                throw new JexlException(node, "=~ error", (Throwable)e);
            }
            Iterator<?> it = this.uberspect.getIterator(right, node);
            if (it != null) {
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next != left && (next == null || !next.equals(left))) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return this.arithmetic.equals(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "=~ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTIdentifier node, Object data) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        String name = node.image;
        if (data == null) {
            int register = node.getRegister();
            if (register >= 0) {
                return this.registers[register];
            }
            Object value = this.context.get(name);
            if (!(value != null || node.jjtGetParent() instanceof ASTReference || this.context.has(name) || this.isTernaryProtected(node))) {
                JexlException.Variable xjexl = new JexlException.Variable(node, name);
                return this.unknownVariable(xjexl);
            }
            return value;
        }
        return this.getAttribute(data, name, node);
    }

    @Deprecated
    public Object visit(ASTFloatLiteral node, Object data) {
        throw new UnsupportedOperationException("Method should not be called; only present for API compatibiltiy");
    }

    @Deprecated
    public Object visit(ASTIntegerLiteral node, Object data) {
        throw new UnsupportedOperationException("Method should not be called; only present for API compatibiltiy");
    }

    public Object visit(ASTVar node, Object data) {
        return this.visit((ASTIdentifier)node, data);
    }

    public Object visit(ASTIfStatement node, Object data) {
        int n = 0;
        try {
            Object result = null;
            Object expression = node.jjtGetChild(0).jjtAccept(this, data);
            if (this.arithmetic.toBoolean(expression)) {
                n = 1;
                result = node.jjtGetChild(1).jjtAccept(this, data);
            } else if (node.jjtGetNumChildren() == 3) {
                n = 2;
                result = node.jjtGetChild(2).jjtAccept(this, data);
            }
            return result;
        }
        catch (JexlException error) {
            throw error;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(n), "if error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNumberLiteral node, Object data) {
        if (data != null && node.isInteger()) {
            return this.getAttribute(data, node.getLiteral(), node);
        }
        return node.getLiteral();
    }

    public Object visit(ASTJexlScript node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        for (int i2 = 0; i2 < numChildren; ++i2) {
            JexlNode child = node.jjtGetChild(i2);
            result = child.jjtAccept(this, data);
        }
        return result;
    }

    public Object visit(ASTLENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.lessThanOrEqual(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "<= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTLTNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.lessThan(left, right) ? Boolean.TRUE : Boolean.FALSE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "< error", (Throwable)xrt);
        }
    }

    public Object visit(ASTMapEntry node, Object data) {
        Object key = node.jjtGetChild(0).jjtAccept(this, data);
        Object value = node.jjtGetChild(1).jjtAccept(this, data);
        return new Object[]{key, value};
    }

    public Object visit(ASTMapLiteral node, Object data) {
        int childCount = node.jjtGetNumChildren();
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i2 = 0; i2 < childCount; ++i2) {
            Object[] entry = (Object[])node.jjtGetChild(i2).jjtAccept(this, data);
            map.put(entry[0], entry[1]);
        }
        return map;
    }

    private Object call(JexlNode node, Object bean, ASTIdentifier methodNode, int argb) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        String methodName = methodNode.image;
        int argc = node.jjtGetNumChildren() - argb;
        Object[] argv = new Object[argc];
        for (int i2 = 0; i2 < argc; ++i2) {
            argv[i2] = node.jjtGetChild(i2 + argb).jjtAccept(this, null);
        }
        JexlException xjexl = null;
        try {
            Object eval;
            JexlMethod me;
            Object cached;
            if (this.cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(me = (JexlMethod)cached).tryFailed(eval = me.tryInvoke(methodName, bean, argv))) {
                return eval;
            }
            boolean cacheable = this.cache;
            JexlMethod vm = this.uberspect.getMethod(bean, methodName, argv, node);
            if (vm == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    vm = this.uberspect.getMethod(bean, methodName, argv, node);
                }
                if (vm == null) {
                    Object functor = null;
                    if (bean == this.context) {
                        int register = methodNode.getRegister();
                        functor = register >= 0 ? this.registers[register] : this.context.get(methodName);
                    } else {
                        JexlPropertyGet gfunctor = this.uberspect.getPropertyGet(bean, methodName, node);
                        if (gfunctor != null) {
                            functor = gfunctor.tryInvoke(bean, methodName);
                        }
                    }
                    if (functor instanceof Script) {
                        return ((Script)functor).execute(this.context, (Object[])(argv.length > 0 ? argv : null));
                    }
                    if (functor instanceof JexlMethod) {
                        vm = (JexlMethod)functor;
                        cacheable = false;
                    } else {
                        xjexl = new JexlException.Method(node, methodName);
                    }
                }
            }
            if (xjexl == null) {
                eval = vm.invoke(bean, argv);
                if (cacheable && vm.isCacheable()) {
                    node.jjtSetValue(vm);
                }
                return eval;
            }
        }
        catch (InvocationTargetException e) {
            xjexl = new JexlException(node, "method invocation error", e.getCause());
        }
        catch (Exception e) {
            xjexl = new JexlException(node, "method error", (Throwable)e);
        }
        return this.invocationFailed(xjexl);
    }

    public Object visit(ASTMethodNode node, Object data) {
        if (data == null) {
            if (node.jjtGetParent().jjtGetChild(0) == node) {
                data = this.resolveNamespace(null, node);
                if (data == null) {
                    data = this.context;
                }
            } else {
                throw new JexlException(node, "attempting to call method on null");
            }
        }
        ASTIdentifier methodNode = (ASTIdentifier)node.jjtGetChild(0);
        return this.call(node, data, methodNode, 1);
    }

    public Object visit(ASTFunctionNode node, Object data) {
        String prefix = node.jjtGetChild((int)0).image;
        Object namespace = this.resolveNamespace(prefix, node);
        ASTIdentifier functionNode = (ASTIdentifier)node.jjtGetChild(1);
        return this.call(node, namespace, functionNode, 2);
    }

    public Object visit(ASTConstructorNode node, Object data) {
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        Object cobject = node.jjtGetChild(0).jjtAccept(this, data);
        int argc = node.jjtGetNumChildren() - 1;
        Object[] argv = new Object[argc];
        for (int i2 = 0; i2 < argc; ++i2) {
            argv[i2] = node.jjtGetChild(i2 + 1).jjtAccept(this, null);
        }
        JexlException xjexl = null;
        try {
            Object eval;
            JexlMethod mctor;
            Object cached;
            if (this.cache && (cached = node.jjtGetValue()) instanceof JexlMethod && !(mctor = (JexlMethod)cached).tryFailed(eval = mctor.tryInvoke(null, cobject, argv))) {
                return eval;
            }
            JexlMethod ctor = this.uberspect.getConstructorMethod(cobject, argv, node);
            if (ctor == null) {
                if (this.arithmetic.narrowArguments(argv)) {
                    ctor = this.uberspect.getConstructorMethod(cobject, argv, node);
                }
                if (ctor == null) {
                    xjexl = new JexlException.Method(node, cobject.toString());
                }
            }
            if (xjexl == null) {
                Object instance = ctor.invoke(cobject, argv);
                if (this.cache && ctor.isCacheable()) {
                    node.jjtSetValue(ctor);
                }
                return instance;
            }
        }
        catch (InvocationTargetException e) {
            xjexl = new JexlException(node, "constructor invocation error", e.getCause());
        }
        catch (Exception e) {
            xjexl = new JexlException(node, "constructor error", (Throwable)e);
        }
        return this.invocationFailed(xjexl);
    }

    public Object visit(ASTModNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.mod(left, right);
        }
        catch (ArithmeticException xrt) {
            if (!this.strict) {
                return new Double(0.0);
            }
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "% error", (Throwable)xrt);
        }
    }

    public Object visit(ASTMulNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.multiply(left, right);
        }
        catch (ArithmeticException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "* error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNENode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            return this.arithmetic.equals(left, right) ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (ArithmeticException xrt) {
            JexlNode xnode = this.findNullOperand(xrt, node, left, right);
            throw new JexlException(xnode, "!= error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNRNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            if (right instanceof Pattern || right instanceof String) {
                return this.arithmetic.matches(left, right) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (right instanceof Set) {
                return ((Set)right).contains(left) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (right instanceof Map) {
                return ((Map)right).containsKey(left) ? Boolean.FALSE : Boolean.TRUE;
            }
            if (right instanceof Collection) {
                return ((Collection)right).contains(left) ? Boolean.FALSE : Boolean.TRUE;
            }
            try {
                Object[] argv = new Object[]{left};
                JexlMethod vm = this.uberspect.getMethod(right, "contains", argv, node);
                if (vm != null) {
                    return this.arithmetic.toBoolean(vm.invoke(right, argv)) ? Boolean.FALSE : Boolean.TRUE;
                }
                if (this.arithmetic.narrowArguments(argv) && (vm = this.uberspect.getMethod(right, "contains", argv, node)) != null) {
                    return this.arithmetic.toBoolean(vm.invoke(right, argv)) ? Boolean.FALSE : Boolean.TRUE;
                }
            }
            catch (InvocationTargetException e) {
                throw new JexlException(node, "!~ invocation error", e.getCause());
            }
            catch (Exception e) {
                throw new JexlException(node, "!~ error", (Throwable)e);
            }
            Iterator<?> it = this.uberspect.getIterator(right, node.jjtGetChild(1));
            if (it != null) {
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next != left && (next == null || !next.equals(left))) continue;
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            return this.arithmetic.equals(left, right) ? Boolean.FALSE : Boolean.TRUE;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node, "!~ error", (Throwable)xrt);
        }
    }

    public Object visit(ASTNotNode node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        return this.arithmetic.toBoolean(val) ? Boolean.FALSE : Boolean.TRUE;
    }

    public Object visit(ASTNullLiteral node, Object data) {
        return null;
    }

    public Object visit(ASTOrNode node, Object data) {
        Object left = node.jjtGetChild(0).jjtAccept(this, data);
        try {
            boolean leftValue = this.arithmetic.toBoolean(left);
            if (leftValue) {
                return Boolean.TRUE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(0), "boolean coercion error", (Throwable)xrt);
        }
        Object right = node.jjtGetChild(1).jjtAccept(this, data);
        try {
            boolean rightValue = this.arithmetic.toBoolean(right);
            if (rightValue) {
                return Boolean.TRUE;
            }
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(node.jjtGetChild(1), "boolean coercion error", (Throwable)xrt);
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTReference node, Object data) {
        int numChildren = node.jjtGetNumChildren();
        Object result = null;
        StringBuilder variableName = null;
        String propertyName = null;
        boolean isVariable = true;
        int v = 0;
        for (int c = 0; c < numChildren; ++c) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            JexlNode theNode = node.jjtGetChild(c);
            if (result == null && theNode instanceof ASTNumberLiteral && ((ASTNumberLiteral)theNode).isInteger()) {
                isVariable &= v > 0;
            } else {
                isVariable &= theNode instanceof ASTIdentifier;
                result = theNode.jjtAccept(this, result);
            }
            if (result == null && isVariable) {
                if (v == 0) {
                    variableName = new StringBuilder(node.jjtGetChild((int)0).image);
                    v = 1;
                }
                while (v <= c) {
                    variableName.append('.');
                    variableName.append(node.jjtGetChild((int)v).image);
                    ++v;
                }
                result = this.context.get(variableName.toString());
                continue;
            }
            propertyName = theNode.image;
        }
        if (!(result != null || !isVariable || this.isTernaryProtected(node) || this.context.has(variableName.toString()) || numChildren == 1 && node.jjtGetChild(0) instanceof ASTIdentifier && ((ASTIdentifier)node.jjtGetChild(0)).getRegister() >= 0)) {
            JexlException xjexl = propertyName != null ? new JexlException.Property(node, propertyName) : new JexlException.Variable(node, variableName.toString());
            return this.unknownVariable(xjexl);
        }
        return result;
    }

    public Object visit(ASTReferenceExpression node, Object data) {
        ASTReferenceExpression upper = node;
        return this.visit((ASTArrayAccess)upper, data);
    }

    public Object visit(ASTReturnStatement node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        throw new JexlException.Return((JexlNode)node, null, val);
    }

    private boolean isTernaryProtected(JexlNode node) {
        for (JexlNode walk = node.jjtGetParent(); walk != null; walk = walk.jjtGetParent()) {
            if (walk instanceof ASTTernaryNode) {
                return true;
            }
            if (!(walk instanceof ASTReference) && !(walk instanceof ASTArrayAccess)) break;
        }
        return false;
    }

    public Object visit(ASTSizeFunction node, Object data) {
        Object val = node.jjtGetChild(0).jjtAccept(this, data);
        if (val == null) {
            throw new JexlException(node, "size() : argument is null", null);
        }
        return this.sizeOf(node, val);
    }

    public Object visit(ASTSizeMethod node, Object data) {
        return this.sizeOf(node, data);
    }

    public Object visit(ASTStringLiteral node, Object data) {
        if (data != null) {
            return this.getAttribute(data, node.getLiteral(), node);
        }
        return node.image;
    }

    public Object visit(ASTTernaryNode node, Object data) {
        Object condition = node.jjtGetChild(0).jjtAccept(this, data);
        if (node.jjtGetNumChildren() == 3) {
            if (condition != null && this.arithmetic.toBoolean(condition)) {
                return node.jjtGetChild(1).jjtAccept(this, data);
            }
            return node.jjtGetChild(2).jjtAccept(this, data);
        }
        if (condition != null && this.arithmetic.toBoolean(condition)) {
            return condition;
        }
        return node.jjtGetChild(1).jjtAccept(this, data);
    }

    public Object visit(ASTTrueNode node, Object data) {
        return Boolean.TRUE;
    }

    public Object visit(ASTUnaryMinusNode node, Object data) {
        JexlNode valNode = node.jjtGetChild(0);
        Object val = valNode.jjtAccept(this, data);
        try {
            Object number = this.arithmetic.negate(val);
            if (valNode instanceof ASTNumberLiteral && number instanceof Number) {
                number = this.arithmetic.narrowNumber((Number)number, ((ASTNumberLiteral)valNode).getLiteralClass());
            }
            return number;
        }
        catch (ArithmeticException xrt) {
            throw new JexlException(valNode, "arithmetic error", (Throwable)xrt);
        }
    }

    public Object visit(ASTWhileStatement node, Object data) {
        Object result = null;
        JexlNode expressionNode = node.jjtGetChild(0);
        while (this.arithmetic.toBoolean(expressionNode.jjtAccept(this, data))) {
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            if (node.jjtGetNumChildren() <= 1) continue;
            result = node.jjtGetChild(1).jjtAccept(this, data);
        }
        return result;
    }

    private int sizeOf(JexlNode node, Object val) {
        if (val instanceof Collection) {
            return ((Collection)val).size();
        }
        if (val.getClass().isArray()) {
            return Array.getLength(val);
        }
        if (val instanceof Map) {
            return ((Map)val).size();
        }
        if (val instanceof String) {
            return ((String)val).length();
        }
        Object[] params = new Object[]{};
        JexlMethod vm = this.uberspect.getMethod(val, "size", EMPTY_PARAMS, node);
        if (vm != null && vm.getReturnType() == Integer.TYPE) {
            Integer result;
            try {
                result = (Integer)vm.invoke(val, params);
            }
            catch (Exception e) {
                throw new JexlException(node, "size() : error executing", (Throwable)e);
            }
            return result;
        }
        throw new JexlException(node, "size() : unsupported type : " + val.getClass(), null);
    }

    public Object getAttribute(Object object, Object attribute) {
        return this.getAttribute(object, attribute, null);
    }

    protected Object getAttribute(Object object, Object attribute, JexlNode node) {
        block9: {
            Object value;
            JexlPropertyGet vg;
            Object cached;
            if (object == null) {
                throw new JexlException(node, "object is null");
            }
            if (this.isCancelled()) {
                throw new JexlException.Cancel(node);
            }
            if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertyGet && !(vg = (JexlPropertyGet)cached).tryFailed(value = vg.tryInvoke(object, attribute))) {
                return value;
            }
            JexlPropertyGet vg2 = this.uberspect.getPropertyGet(object, attribute, node);
            if (vg2 != null) {
                try {
                    Object value2 = vg2.invoke(object);
                    if (node != null && this.cache && vg2.isCacheable()) {
                        node.jjtSetValue(vg2);
                    }
                    return value2;
                }
                catch (Exception xany) {
                    if (node == null) {
                        throw new RuntimeException(xany);
                    }
                    JexlException.Property xjexl = new JexlException.Property(node, attribute.toString());
                    if (this.strict) {
                        throw xjexl;
                    }
                    if (this.silent) break block9;
                    this.logger.warn(xjexl.getMessage());
                }
            }
        }
        return null;
    }

    public void setAttribute(Object object, Object attribute, Object value) {
        this.setAttribute(object, attribute, value, null);
    }

    protected void setAttribute(Object object, Object attribute, Object value, JexlNode node) {
        Object[] narrow;
        Object eval;
        JexlPropertySet setter;
        Object cached;
        if (this.isCancelled()) {
            throw new JexlException.Cancel(node);
        }
        if (node != null && this.cache && (cached = node.jjtGetValue()) instanceof JexlPropertySet && !(setter = (JexlPropertySet)cached).tryFailed(eval = setter.tryInvoke(object, attribute, value))) {
            return;
        }
        JexlException xjexl = null;
        JexlPropertySet vs = this.uberspect.getPropertySet(object, attribute, value, node);
        if (vs == null && this.arithmetic.narrowArguments(narrow = new Object[]{value})) {
            vs = this.uberspect.getPropertySet(object, attribute, narrow[0], node);
        }
        if (vs != null) {
            try {
                vs.invoke(object, value);
                if (node != null && this.cache && vs.isCacheable()) {
                    node.jjtSetValue(vs);
                }
                return;
            }
            catch (RuntimeException xrt) {
                if (node == null) {
                    throw xrt;
                }
                xjexl = new JexlException(node, "set object property error", (Throwable)xrt);
            }
            catch (Exception xany) {
                if (node == null) {
                    throw new RuntimeException(xany);
                }
                xjexl = new JexlException(node, "set object property error", (Throwable)xany);
            }
        }
        if (xjexl == null) {
            if (node == null) {
                String error = "unable to set object property, class: " + object.getClass().getName() + ", property: " + attribute + ", argument: " + value.getClass().getSimpleName();
                throw new UnsupportedOperationException(error);
            }
            xjexl = new JexlException.Property(node, attribute.toString());
        }
        if (this.strict) {
            throw xjexl;
        }
        if (!this.silent) {
            this.logger.warn(xjexl.getMessage());
        }
    }

    public Object visit(SimpleNode node, Object data) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object visit(ASTAmbiguous node, Object data) {
        throw new UnsupportedOperationException("unexpected type of node");
    }
}

