/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.tribble.TribbleException;
import htsjdk.variant.vcf.VCFTextTransformer;
import java.util.List;
import java.util.stream.Collectors;

public class VCFPercentEncodedTextTransformer
implements VCFTextTransformer {
    private static final String ENCODING_SENTINEL_STRING = "%";
    private static final char ENCODING_SENTNEL_CHAR = '%';
    private static final int ENCODING_BASE_RADIX = 16;

    @Override
    public String decodeText(String rawPart) {
        return VCFPercentEncodedTextTransformer.decodePercentEncodedChars(rawPart);
    }

    @Override
    public List<String> decodeText(List<String> rawParts) {
        return rawParts.stream().map(this::decodeText).collect(Collectors.toList());
    }

    protected static String decodePercentEncodedChars(String rawText) {
        if (rawText.contains(ENCODING_SENTINEL_STRING)) {
            StringBuilder builder = new StringBuilder(rawText.length());
            for (int i2 = 0; i2 < rawText.length(); ++i2) {
                char c = rawText.charAt(i2);
                if (c == '%' && i2 + 2 < rawText.length()) {
                    try {
                        char[] trans = Character.toChars(Integer.parseInt(rawText.substring(i2 + 1, i2 + 3), 16));
                        if (trans.length != 1) {
                            throw new TribbleException(String.format("escape sequence '%c' corresponds to an invalid encoding in '%s'", Character.valueOf(c), rawText));
                        }
                        builder.append(trans[0]);
                        i2 += 2;
                    }
                    catch (IllegalArgumentException e) {
                        builder.append(c);
                    }
                    continue;
                }
                builder.append(c);
            }
            return builder.toString();
        }
        return rawText;
    }
}

