/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.util.RuntimeIOException;
import htsjdk.tribble.util.ParsingUtils;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.LazyGenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.IntGenotypeFieldAccessors;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class VCFEncoder {
    public static final Charset VCF_CHARSET = StandardCharsets.ISO_8859_1;
    private static final String QUAL_FORMAT_STRING = "%.2f";
    private static final String QUAL_FORMAT_EXTENSION_TO_TRIM = ".00";
    private final IntGenotypeFieldAccessors GENOTYPE_FIELD_ACCESSORS = new IntGenotypeFieldAccessors();
    private VCFHeader header;
    private boolean allowMissingFieldsInHeader = false;
    private boolean outputTrailingFormatFields = false;

    public VCFEncoder(VCFHeader header, boolean allowMissingFieldsInHeader, boolean outputTrailingFormatFields) {
        if (header == null) {
            throw new NullPointerException("The VCF header must not be null.");
        }
        this.header = header;
        this.allowMissingFieldsInHeader = allowMissingFieldsInHeader;
        this.outputTrailingFormatFields = outputTrailingFormatFields;
    }

    @Deprecated
    public void setVCFHeader(VCFHeader header) {
        this.header = header;
    }

    @Deprecated
    public void setAllowMissingFieldsInHeader(boolean allow) {
        this.allowMissingFieldsInHeader = allow;
    }

    public String encode(VariantContext context) {
        try {
            StringBuilder stringBuilder = new StringBuilder(1000);
            this.write(stringBuilder, context);
            return stringBuilder.toString();
        }
        catch (IOException error) {
            throw new RuntimeIOException("Cannot encode variant", error);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void write(Appendable vcfOutput, VariantContext context) throws IOException {
        if (this.header == null) {
            throw new NullPointerException("The header field must be set on the VCFEncoder before encoding records.");
        }
        vcfOutput.append(context.getContig()).append("\t").append(String.valueOf(context.getStart())).append("\t").append(context.getID()).append("\t").append(context.getReference().getDisplayString()).append("\t");
        if (context.isVariant()) {
            void var5_6;
            Allele altAllele = context.getAlternateAllele(0);
            Object alt = altAllele.getDisplayString();
            vcfOutput.append((CharSequence)alt);
            boolean bl = true;
            while (var5_6 < context.getAlternateAlleles().size()) {
                altAllele = context.getAlternateAllele((int)var5_6);
                alt = altAllele.getDisplayString();
                vcfOutput.append(',');
                vcfOutput.append((CharSequence)alt);
                ++var5_6;
            }
        } else {
            vcfOutput.append(".");
        }
        vcfOutput.append("\t");
        if (!context.hasLog10PError()) {
            vcfOutput.append(".");
        } else {
            vcfOutput.append(VCFEncoder.formatQualValue(context.getPhredScaledQual()));
        }
        vcfOutput.append("\t").append(this.getFilterString(context)).append("\t");
        TreeMap<String, String> infoFields = new TreeMap<String, String>();
        for (Map.Entry entry : context.getAttributes().entrySet()) {
            Object outputValue;
            if (!this.header.hasInfoLine((String)entry.getKey())) {
                this.fieldIsMissingFromHeaderError(context, (String)entry.getKey(), "INFO");
            }
            if ((outputValue = this.formatVCFField(entry.getValue())) == null) continue;
            infoFields.put((String)entry.getKey(), (String)outputValue);
        }
        this.writeInfoString(infoFields, vcfOutput);
        GenotypesContext gc = context.getGenotypes();
        if (gc.isLazyWithData() && ((LazyGenotypesContext)gc).getUnparsedGenotypeData() instanceof String) {
            vcfOutput.append("\t");
            vcfOutput.append(((LazyGenotypesContext)gc).getUnparsedGenotypeData().toString());
        } else {
            List<String> list = context.calcVCFGenotypeKeys(this.header);
            if (!list.isEmpty()) {
                for (String format : list) {
                    if (this.header.hasFormatLine(format)) continue;
                    this.fieldIsMissingFromHeaderError(context, format, "FORMAT");
                }
                String genotypeFormatString = ParsingUtils.join(":", list);
                vcfOutput.append("\t");
                vcfOutput.append(genotypeFormatString);
                Map<Allele, String> alleleStrings = this.buildAlleleStrings(context);
                this.appendGenotypeData(context, alleleStrings, list, vcfOutput);
            }
        }
    }

    VCFHeader getVCFHeader() {
        return this.header;
    }

    boolean getAllowMissingFieldsInHeader() {
        return this.allowMissingFieldsInHeader;
    }

    private String getFilterString(VariantContext vc) {
        if (vc.isFiltered()) {
            for (String filter : vc.getFilters()) {
                if (this.header.hasFilterLine(filter)) continue;
                this.fieldIsMissingFromHeaderError(vc, filter, "FILTER");
            }
            return ParsingUtils.join(";", ParsingUtils.sortList(vc.getFilters()));
        }
        return vc.filtersWereApplied() ? "PASS" : ".";
    }

    private static String formatQualValue(double qual) {
        String s = String.format(Locale.US, QUAL_FORMAT_STRING, qual);
        if (s.endsWith(QUAL_FORMAT_EXTENSION_TO_TRIM)) {
            s = s.substring(0, s.length() - QUAL_FORMAT_EXTENSION_TO_TRIM.length());
        }
        return s;
    }

    private void fieldIsMissingFromHeaderError(VariantContext vc, String id, String field) {
        if (!this.allowMissingFieldsInHeader) {
            throw new IllegalStateException("Key " + id + " found in VariantContext field " + field + " at " + vc.getContig() + ":" + vc.getStart() + " but this key isn't defined in the VCFHeader.  We require all VCFs to have complete VCF headers by default.");
        }
    }

    String formatVCFField(Object val) {
        String result;
        if (val == null) {
            result = ".";
        } else if (val instanceof Double) {
            result = VCFEncoder.formatVCFDouble((Double)val);
        } else if (val instanceof Boolean) {
            result = (Boolean)val != false ? "" : null;
        } else if (val instanceof List) {
            result = this.formatVCFField(((List)val).toArray());
        } else if (val.getClass().isArray()) {
            int length = Array.getLength(val);
            if (length == 0) {
                return this.formatVCFField(null);
            }
            StringBuilder sb = new StringBuilder(this.formatVCFField(Array.get(val, 0)));
            for (int i2 = 1; i2 < length; ++i2) {
                sb.append(',');
                sb.append(this.formatVCFField(Array.get(val, i2)));
            }
            result = sb.toString();
        } else {
            result = val.toString();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String formatVCFDouble(double d) {
        String format;
        if (d < 1.0) {
            if (d < 0.01) {
                if (!(Math.abs(d) >= 1.0E-20)) return "0.00";
                format = "%.3e";
                return String.format(Locale.US, format, d);
            } else {
                format = "%.3f";
            }
            return String.format(Locale.US, format, d);
        } else {
            format = QUAL_FORMAT_STRING;
        }
        return String.format(Locale.US, format, d);
    }

    static int countOccurrences(char c, String s) {
        int count = 0;
        for (int i2 = 0; i2 < s.length(); ++i2) {
            count += s.charAt(i2) == c ? 1 : 0;
        }
        return count;
    }

    static boolean isMissingValue(String s) {
        return VCFEncoder.countOccurrences(".".charAt(0), s) + VCFEncoder.countOccurrences(',', s) == s.length();
    }

    public void addGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys, StringBuilder builder) {
        try {
            this.appendGenotypeData(vc, alleleMap, genotypeFormatKeys, builder);
        }
        catch (IOException err) {
            throw new RuntimeIOException("addGenotypeData failed", err);
        }
    }

    private void appendGenotypeData(VariantContext vc, Map<Allele, String> alleleMap, List<String> genotypeFormatKeys, Appendable vcfoutput) throws IOException {
        int ploidy = vc.getMaxPloidy(2);
        for (String sample : this.header.getGenotypeSamples()) {
            vcfoutput.append("\t");
            Genotype g = vc.getGenotype(sample);
            if (g == null) {
                g = GenotypeBuilder.createMissing(sample, ploidy);
            }
            ArrayList<String> attrs = new ArrayList<String>(genotypeFormatKeys.size());
            for (String field : genotypeFormatKeys) {
                String outputValue;
                if (field.equals("GT")) {
                    if (!g.isAvailable()) {
                        throw new IllegalStateException("GTs cannot be missing for some samples if they are available for others in the record");
                    }
                    VCFEncoder.writeAllele(g.getAllele(0), alleleMap, vcfoutput);
                    for (int i2 = 1; i2 < g.getPloidy(); ++i2) {
                        vcfoutput.append(g.isPhased() ? "|" : "/");
                        VCFEncoder.writeAllele(g.getAllele(i2), alleleMap, vcfoutput);
                    }
                    continue;
                }
                if (field.equals("FT")) {
                    outputValue = g.isFiltered() ? g.getFilters() : "PASS";
                } else {
                    IntGenotypeFieldAccessors.Accessor accessor = this.GENOTYPE_FIELD_ACCESSORS.getAccessor(field);
                    if (accessor != null) {
                        int[] intValues = accessor.getValues(g);
                        if (intValues == null) {
                            outputValue = ".";
                        } else if (intValues.length == 1) {
                            outputValue = Integer.toString(intValues[0]);
                        } else {
                            StringBuilder sb = new StringBuilder();
                            sb.append(intValues[0]);
                            for (int i3 = 1; i3 < intValues.length; ++i3) {
                                sb.append(',');
                                sb.append(intValues[i3]);
                            }
                            outputValue = sb.toString();
                        }
                    } else {
                        String val = g.hasExtendedAttribute(field) ? g.getExtendedAttribute(field) : ".";
                        outputValue = this.formatVCFField(val);
                    }
                }
                if (outputValue == null) continue;
                attrs.add(outputValue);
            }
            if (!this.outputTrailingFormatFields) {
                for (int i4 = attrs.size() - 1; i4 >= 0 && VCFEncoder.isMissingValue((String)attrs.get(i4)); --i4) {
                    attrs.remove(i4);
                }
            }
            for (int i5 = 0; i5 < attrs.size(); ++i5) {
                if (i5 > 0 || genotypeFormatKeys.contains("GT")) {
                    vcfoutput.append(":");
                }
                vcfoutput.append((CharSequence)attrs.get(i5));
            }
        }
    }

    private void writeInfoString(Map<String, String> infoFields, Appendable vcfoutput) throws IOException {
        if (infoFields.isEmpty()) {
            vcfoutput.append(".");
            return;
        }
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : infoFields.entrySet()) {
            VCFInfoHeaderLine metaData;
            if (isFirst) {
                isFirst = false;
            } else {
                vcfoutput.append(";");
            }
            vcfoutput.append(entry.getKey());
            if (entry.getValue().isEmpty() || (metaData = this.header.getInfoHeaderLine(entry.getKey())) != null && metaData.getCountType() == VCFHeaderLineCount.INTEGER && metaData.getCount() == 0) continue;
            vcfoutput.append('=');
            vcfoutput.append(entry.getValue());
        }
    }

    public Map<Allele, String> buildAlleleStrings(VariantContext vc) {
        HashMap<Allele, String> alleleMap = new HashMap<Allele, String>(vc.getAlleles().size() + 1);
        alleleMap.put(Allele.NO_CALL, ".");
        List<Allele> alleles = vc.getAlleles();
        for (int i2 = 0; i2 < alleles.size(); ++i2) {
            alleleMap.put(alleles.get(i2), String.valueOf(i2));
        }
        return alleleMap;
    }

    private static void writeAllele(Allele allele, Map<Allele, String> alleleMap, Appendable vcfOutput) throws IOException {
        String encoding = alleleMap.get(allele);
        if (encoding == null) {
            throw new RuntimeException("Allele " + allele + " is not an allele in the variant context");
        }
        vcfOutput.append(encoding);
    }
}

