/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.variant.variantcontext.VariantContext;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;

class VariantJEXLContext
implements JexlContext {
    private VariantContext vc;
    static final String true_string = "1";
    static final String false_string = "0";
    private static Map<String, AttributeGetter> attributes = new HashMap<String, AttributeGetter>();

    public VariantJEXLContext(VariantContext vc) {
        this.vc = vc;
    }

    @Override
    public Object get(String name) {
        Object result = null;
        if (attributes.containsKey(name)) {
            result = attributes.get(name).get(this.vc);
        } else if (this.vc.hasAttribute(name)) {
            result = this.vc.getAttribute(name);
        } else if (this.vc.getFilters().contains(name)) {
            result = true_string;
        }
        return result;
    }

    @Override
    public boolean has(String name) {
        return this.get(name) != null;
    }

    @Override
    public void set(String name, Object value) {
        throw new UnsupportedOperationException("remove() not supported on a VariantJEXLContext");
    }

    static {
        attributes.put("vc", vc -> vc);
        attributes.put("CHROM", VariantContext::getContig);
        attributes.put("POS", VariantContext::getStart);
        attributes.put("TYPE", vc -> vc.getType().toString());
        attributes.put("QUAL", vc -> -10.0 * vc.getLog10PError());
        attributes.put("ALLELES", VariantContext::getAlleles);
        attributes.put("N_ALLELES", VariantContext::getNAlleles);
        attributes.put("FILTER", vc -> vc.isFiltered() ? true_string : false_string);
        attributes.put("homRefCount", VariantContext::getHomRefCount);
        attributes.put("hetCount", VariantContext::getHetCount);
        attributes.put("homVarCount", VariantContext::getHomVarCount);
    }

    private static interface AttributeGetter {
        public Object get(VariantContext var1);
    }
}

