/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.utils;

public class BinomialCoefficientUtil {
    public static long binomialCoefficient(int n, int k) throws ArithmeticException {
        BinomialCoefficientUtil.checkBinomial(n, k);
        if (n == k || k == 0) {
            return 1L;
        }
        if (k == 1 || k == n - 1) {
            return n;
        }
        if (k > n / 2) {
            return BinomialCoefficientUtil.binomialCoefficient(n, n - k);
        }
        long result = 1L;
        if (n <= 61) {
            int i2 = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                result = result * (long)i2 / (long)j;
                ++i2;
            }
        } else if (n <= 66) {
            int i3 = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                long d = BinomialCoefficientUtil.gcd(i3, j);
                result = result / ((long)j / d) * ((long)i3 / d);
                ++i3;
            }
        } else {
            int i4 = n - k + 1;
            for (int j = 1; j <= k; ++j) {
                long d = BinomialCoefficientUtil.gcd(i4, j);
                result = BinomialCoefficientUtil.mulAndCheck(result / ((long)j / d), (long)i4 / d);
                ++i4;
            }
        }
        return result;
    }

    private static void checkBinomial(int n, int k) throws IllegalArgumentException {
        if (n < k) {
            throw new IllegalArgumentException("The first value (" + n + ") must not be exceeded by the second value (" + k + ") in a binomial coefficient");
        }
        if (n < 0) {
            throw new IllegalArgumentException("The first value (" + n + ") in a binomial coefficient must not be negative.");
        }
    }

    private static int gcd(int p, int q) throws ArithmeticException {
        int a = p;
        int b = q;
        if (a == 0 || b == 0) {
            if (a == Integer.MIN_VALUE || b == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: gcd(" + p + ", " + q + ") is 2^31");
            }
            return Math.abs(a + b);
        }
        long al = a;
        long bl = b;
        boolean useLong = false;
        if (a < 0) {
            if (Integer.MIN_VALUE == a) {
                useLong = true;
            } else {
                a = -a;
            }
            al = -al;
        }
        if (b < 0) {
            if (Integer.MIN_VALUE == b) {
                useLong = true;
            } else {
                b = -b;
            }
            bl = -bl;
        }
        if (useLong) {
            if (al == bl) {
                throw new ArithmeticException("overflow: gcd(" + p + ", " + q + ") is 2^31");
            }
            long blbu = bl;
            bl = al;
            if ((al = blbu % al) == 0L) {
                if (bl > Integer.MAX_VALUE) {
                    throw new ArithmeticException("overflow: gcd(" + p + ", " + q + ") is 2^31");
                }
                return (int)bl;
            }
            blbu = bl;
            b = (int)al;
            a = (int)(blbu % al);
        }
        return BinomialCoefficientUtil.gcdPositive(a, b);
    }

    private static int gcdPositive(int a, int b) {
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        int aTwos = Integer.numberOfTrailingZeros(a);
        a >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b);
        b >>= bTwos;
        int shift = Math.min(aTwos, bTwos);
        while (a != b) {
            int delta = a - b;
            b = Math.min(a, b);
            a = Math.abs(delta);
            a >>= Integer.numberOfTrailingZeros(a);
        }
        return a << shift;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long mulAndCheck(long a, long b) throws ArithmeticException {
        if (a > b) {
            return BinomialCoefficientUtil.mulAndCheck(b, a);
        }
        if (a < 0L) {
            if (b < 0L) {
                if (a < Long.MAX_VALUE / b) throw new ArithmeticException();
                return a * b;
            }
            if (b <= 0L) return 0L;
            if (Long.MIN_VALUE / b > a) throw new ArithmeticException();
            return a * b;
        }
        if (a <= 0L) return 0L;
        if (a > Long.MAX_VALUE / b) throw new ArithmeticException();
        return a * b;
    }
}

