/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.interval;

import htsjdk.samtools.util.IOUtil;
import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.interval.MutableInterval;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;

public class IntervalIndexCreator
extends TribbleIndexCreator {
    public static final int DEFAULT_FEATURE_COUNT = 600;
    private int featuresPerInterval = 600;
    private final LinkedList<IntervalTreeIndex.ChrIndex> chrList = new LinkedList();
    private int featureCount = 0;
    private final ArrayList<MutableInterval> intervals = new ArrayList();
    Path inputPath;

    public IntervalIndexCreator(Path inputPath, int featuresPerInterval) {
        this.inputPath = inputPath;
        this.featuresPerInterval = featuresPerInterval;
    }

    public IntervalIndexCreator(File inputFile, int featuresPerInterval) {
        this(IOUtil.toPath(inputFile), featuresPerInterval);
    }

    public IntervalIndexCreator(File inputFile) {
        this(IOUtil.toPath(inputFile));
    }

    public IntervalIndexCreator(Path inputPath) {
        this(inputPath, 600);
    }

    @Override
    public void addFeature(Feature feature, long filePosition) {
        if (this.chrList.isEmpty() || !this.chrList.getLast().getName().equals(feature.getContig())) {
            if (!this.chrList.isEmpty()) {
                this.addIntervalsToLastChr(filePosition);
            }
            this.chrList.add(new IntervalTreeIndex.ChrIndex(feature.getContig()));
            this.intervals.clear();
        }
        if (this.featureCount >= this.featuresPerInterval || this.intervals.isEmpty()) {
            MutableInterval i2 = new MutableInterval();
            i2.setStart(feature.getStart());
            i2.setStartFilePosition(filePosition);
            if (!this.intervals.isEmpty()) {
                this.intervals.get(this.intervals.size() - 1).setEndFilePosition(filePosition);
            }
            this.featureCount = 0;
            this.intervals.add(i2);
        }
        this.intervals.get(this.intervals.size() - 1).setStop(Math.max(feature.getEnd(), this.intervals.get(this.intervals.size() - 1).getStop()));
        ++this.featureCount;
    }

    private void addIntervalsToLastChr(long currentPos) {
        for (int x = 0; x < this.intervals.size(); ++x) {
            if (x == this.intervals.size() - 1) {
                this.intervals.get(x).setEndFilePosition(currentPos);
            }
            this.chrList.getLast().insert(this.intervals.get(x).toInterval());
        }
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        IntervalTreeIndex featureIndex = new IntervalTreeIndex(this.inputPath);
        this.addIntervalsToLastChr(finalFilePosition);
        featureIndex.setChrIndex(this.chrList);
        featureIndex.addProperties(this.properties);
        featureIndex.finalizeIndex();
        return featureIndex;
    }

    public int getFeaturesPerInterval() {
        return this.featuresPerInterval;
    }
}

