/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.IntervalList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SamLocusIterator
extends AbstractLocusIterator<RecordAndOffset, LocusInfo> {
    public SamLocusIterator(SamReader samReader) {
        this(samReader, null);
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public SamLocusIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        super(samReader, intervalList, useIndex);
    }

    @Override
    void accumulateSamRecord(SAMRecord rec) {
        this.prepareAccumulatorForRecord(rec);
        int minQuality = this.getQualityScoreCutoff();
        boolean dontCheckQualities = minQuality == 0;
        byte[] baseQualities = dontCheckQualities ? null : rec.getBaseQualities();
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            int readStart = alignmentBlock.getReadStart();
            int blockLength = alignmentBlock.getLength();
            int blockStartAccIndex = alignmentBlock.getReferenceStart() - ((LocusInfo)this.accumulator.get(0)).getPosition();
            for (int i2 = 0; i2 < blockLength; ++i2) {
                int readOffset = readStart + i2 - 1;
                if (!dontCheckQualities && baseQualities.length != 0 && baseQualities[readOffset] < minQuality) continue;
                int accumulateIndex = blockStartAccIndex + i2;
                ((LocusInfo)this.accumulator.get(accumulateIndex)).add(new RecordAndOffset(rec, readOffset));
            }
        }
    }

    @Override
    void accumulateIndels(SAMRecord rec) {
        int minQuality = this.getQualityScoreCutoff();
        boolean dontCheckQualities = minQuality == 0;
        byte[] baseQualities = dontCheckQualities ? null : rec.getBaseQualities();
        List<CigarElement> cigar = rec.getCigar().getCigarElements();
        int readBase = 0;
        int baseAccIndex = rec.getAlignmentStart() - ((LocusInfo)this.accumulator.get(0)).getPosition();
        for (int elementIndex = 0; elementIndex < cigar.size(); ++elementIndex) {
            CigarElement e = cigar.get(elementIndex);
            CigarOperator operator = e.getOperator();
            if (operator.equals((Object)CigarOperator.I)) {
                if (!dontCheckQualities && baseQualities.length != 0 && baseQualities[readBase] < minQuality) continue;
                ((LocusInfo)this.accumulator.get(baseAccIndex - 1)).addInserted(rec, readBase);
                readBase += e.getLength();
                continue;
            }
            if (operator.equals((Object)CigarOperator.D)) {
                for (int i2 = 0; i2 < e.getLength(); ++i2) {
                    ((LocusInfo)this.accumulator.get(baseAccIndex + i2)).addDeleted(rec, readBase - 1);
                }
                baseAccIndex += e.getLength();
                continue;
            }
            if (operator.consumesReadBases()) {
                readBase += e.getLength();
            }
            if (!operator.consumesReferenceBases()) continue;
            baseAccIndex += e.getLength();
        }
    }

    private void prepareAccumulatorForRecord(SAMRecord rec) {
        SAMSequenceRecord ref = this.getReferenceSequence(rec.getReferenceIndex());
        int alignmentStart = rec.getAlignmentStart();
        int alignmentEnd = rec.getAlignmentEnd();
        int alignmentLength = alignmentEnd - alignmentStart;
        if (this.includeIndels && SamLocusIterator.startWithInsertion(rec.getCigar()) && (this.accumulator.isEmpty() || ((LocusInfo)this.accumulator.get(0)).getPosition() == alignmentStart)) {
            this.accumulator.add(0, new LocusInfo(ref, alignmentStart - 1));
        }
        int accIndexWhereReadStarts = this.accumulator.isEmpty() ? 0 : alignmentStart - ((LocusInfo)this.accumulator.get(0)).getPosition();
        int newLocusesCount = accIndexWhereReadStarts + alignmentLength - this.accumulator.size();
        for (int i2 = 0; i2 <= newLocusesCount; ++i2) {
            this.accumulator.add(new LocusInfo(ref, alignmentEnd - newLocusesCount + i2));
        }
    }

    @Override
    RecordAndOffset createRecordAndOffset(SAMRecord rec, int readOffset, int length, int refPos) {
        return new RecordAndOffset(rec, readOffset);
    }

    @Override
    LocusInfo createLocusInfo(SAMSequenceRecord referenceSequence, int lastPosition) {
        return new LocusInfo(referenceSequence, lastPosition);
    }

    public static final class LocusInfo
    extends AbstractLocusInfo<RecordAndOffset> {
        private List<RecordAndOffset> deletedInRecord = null;
        private List<RecordAndOffset> insertedInRecord = null;

        public LocusInfo(SAMSequenceRecord referenceSequence, int position) {
            super(referenceSequence, position);
        }

        public void addDeleted(SAMRecord read, int previousPosition) {
            if (this.deletedInRecord == null) {
                this.deletedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.deletedInRecord.add(new RecordAndOffset(read, previousPosition, AbstractRecordAndOffset.AlignmentType.Deletion));
        }

        public void addInserted(SAMRecord read, int firstPosition) {
            if (this.insertedInRecord == null) {
                this.insertedInRecord = new ArrayList<RecordAndOffset>();
            }
            this.insertedInRecord.add(new RecordAndOffset(read, firstPosition, AbstractRecordAndOffset.AlignmentType.Insertion));
        }

        public List<RecordAndOffset> getDeletedInRecord() {
            return this.deletedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.deletedInRecord);
        }

        public List<RecordAndOffset> getInsertedInRecord() {
            return this.insertedInRecord == null ? Collections.emptyList() : Collections.unmodifiableList(this.insertedInRecord);
        }

        @Override
        public int size() {
            return super.size() + (this.deletedInRecord == null ? 0 : this.deletedInRecord.size());
        }

        @Override
        public boolean isEmpty() {
            return !(!this.getRecordAndOffsets().isEmpty() || this.deletedInRecord != null && !this.deletedInRecord.isEmpty() || this.insertedInRecord != null && !this.insertedInRecord.isEmpty());
        }
    }

    public static class RecordAndOffset
    extends AbstractRecordAndOffset {
        public RecordAndOffset(SAMRecord record, int offset) {
            super(record, offset);
        }

        public RecordAndOffset(SAMRecord record, int offset, AbstractRecordAndOffset.AlignmentType alignmentType) {
            super(record, offset, alignmentType);
        }
    }
}

