/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.SequenceUtil;

public final class QualityUtil {
    private static final double[] errorProbabilityByPhredScore = new double[101];

    public static double getErrorProbabilityFromPhredScore(int i2) {
        return errorProbabilityByPhredScore[i2];
    }

    public static int getPhredScoreFromErrorProbability(double probability) {
        return (int)Math.round(-10.0 * Math.log10(probability));
    }

    public static int getPhredScoreFromObsAndErrors(double observations, double errors) {
        return QualityUtil.getPhredScoreFromErrorProbability(errors / observations);
    }

    public static double sumOfErrorProbabilities(SAMRecord rec) {
        byte[] bases = rec.getReadBases();
        byte[] quals = rec.getBaseQualities();
        double sum = 0.0;
        for (int i2 = 0; i2 < bases.length; ++i2) {
            if (SequenceUtil.isNoCall(bases[i2])) {
                sum += 1.0;
                continue;
            }
            sum += QualityUtil.getErrorProbabilityFromPhredScore(quals[i2]);
        }
        return sum;
    }

    static {
        for (int i2 = 0; i2 < errorProbabilityByPhredScore.length; ++i2) {
            QualityUtil.errorProbabilityByPhredScore[i2] = 1.0 / Math.pow(10.0, (double)i2 / 10.0);
        }
    }
}

