/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParser {
    private static boolean check(StringTokenizer st, String token) throws InvalidDateException {
        if (!st.hasMoreElements()) {
            return false;
        }
        if (st.nextToken().equals(token)) {
            return true;
        }
        throw new InvalidDateException("Missing [" + token + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Calendar getCalendar(String isodate) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        try {
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!DateParser.check(st, "T") || !st.hasMoreTokens()) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new InvalidDateException("No secondes specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = nt + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("Z")) return calendar;
            if (!tok.equals("+") && !tok.equals("-")) {
                throw new InvalidDateException("only Z, + or - allowed");
            }
            boolean plus = tok.equals("+");
            if (!st.hasMoreTokens()) {
                throw new InvalidDateException("Missing hour field");
            }
            int tzhour = Integer.parseInt(st.nextToken());
            int tzmin = 0;
            if (DateParser.check(st, ":") && st.hasMoreTokens()) {
                tzmin = Integer.parseInt(st.nextToken());
            } else if (tzhour >= 100) {
                tzmin = tzhour % 100;
                tzhour /= 100;
            }
            if (!plus) {
                ((Calendar)calendar).add(10, tzhour);
                ((Calendar)calendar).add(12, tzmin);
                return calendar;
            } else {
                ((Calendar)calendar).add(10, -tzhour);
                ((Calendar)calendar).add(12, -tzmin);
            }
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    public static Date parse(String isodate) throws InvalidDateException {
        Calendar calendar = DateParser.getCalendar(isodate);
        return calendar.getTime();
    }

    private static String twoDigit(int i2) {
        if (i2 >= 0 && i2 < 10) {
            return "0" + String.valueOf(i2);
        }
        return String.valueOf(i2);
    }

    public static String getIsoDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        return new StringBuffer().append(calendar.get(1)).append("-").append(DateParser.twoDigit(calendar.get(2) + 1)).append("-").append(DateParser.twoDigit(calendar.get(5))).append("T").append(DateParser.twoDigit(calendar.get(11))).append(":").append(DateParser.twoDigit(calendar.get(12))).append(":").append(DateParser.twoDigit(calendar.get(13))).append(".").append(DateParser.twoDigit(calendar.get(14) / 10)).append("Z").toString();
    }

    public static class InvalidDateException
    extends SAMException {
        public InvalidDateException() {
        }

        public InvalidDateException(String s) {
            super(s);
        }

        public InvalidDateException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public InvalidDateException(Throwable throwable) {
            super(throwable);
        }
    }
}

