/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.Chunk;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class CoordSpanInputSteam
extends InputStream {
    private SeekableStream delegate;
    private Iterator<Chunk> it;
    private Chunk current;
    private boolean eof = false;

    public CoordSpanInputSteam(SeekableStream delegate, long[] coords) throws IOException {
        this.delegate = delegate;
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        for (int i2 = 0; i2 < coords.length; i2 += 2) {
            if (coords[i2] > delegate.length()) {
                throw new RuntimeException("Chunk start is passed EOF: " + coords[i2]);
            }
            Chunk chunk = new Chunk(coords[i2], coords[i2 + 1] > delegate.length() ? delegate.length() : coords[i2 + 1]);
            chunks.add(chunk);
            System.err.printf("Adding chunk: %d - %d\n", chunk.getChunkStart(), chunk.getChunkEnd());
        }
        this.it = chunks.iterator();
        this.nextChunk();
    }

    private void nextChunk() throws IOException {
        if (this.eof || !this.it.hasNext()) {
            this.eof = true;
            return;
        }
        this.current = this.it.next();
        this.delegate.seek(this.current.getChunkStart());
    }

    @Override
    public int read() throws IOException {
        if (this.eof || this.delegate.eof()) {
            this.eof = true;
            return -1;
        }
        if (this.delegate.position() < this.current.getChunkEnd()) {
            return this.delegate.read();
        }
        this.nextChunk();
        if (this.eof) {
            return -1;
        }
        return this.delegate.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.eof || this.delegate.eof()) {
            this.eof = true;
            return -1;
        }
        int available = this.available();
        if (available > length) {
            return this.delegate.read(buffer, offset, length);
        }
        int read = this.delegate.read(buffer, offset, available);
        if (this.delegate.position() >= this.current.getChunkEnd()) {
            this.nextChunk();
        }
        return read;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.current.getChunkEnd() - this.delegate.position());
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        this.it = null;
    }
}

