/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SeekableBufferedStream
extends SeekableStream {
    public static final int DEFAULT_BUFFER_SIZE = 512000;
    private final int bufferSize;
    final SeekableStream wrappedStream;
    ExtBufferedInputStream bufferedStream;
    long position;

    public SeekableBufferedStream(SeekableStream stream, int bufferSize) {
        this.bufferSize = bufferSize;
        this.wrappedStream = stream;
        this.position = 0L;
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, bufferSize);
    }

    public SeekableBufferedStream(SeekableStream stream) {
        this(stream, 512000);
    }

    @Override
    public long length() {
        return this.wrappedStream.length();
    }

    @Override
    public long skip(long skipLength) throws IOException {
        if (skipLength < (long)this.bufferedStream.getBytesInBufferAvailable()) {
            long retval = this.bufferedStream.skip(skipLength);
            this.position += retval;
            return retval;
        }
        long position = this.position + skipLength;
        this.seekInternal(position);
        return skipLength;
    }

    @Override
    public void seek(long position) throws IOException {
        if (this.position == position) {
            return;
        }
        long delta = position - this.position;
        if (this.bufferedStream.canChangePos(delta)) {
            this.bufferedStream.changePos((int)delta);
            this.position = position;
        } else {
            this.seekInternal(position);
        }
    }

    private void seekInternal(long position) throws IOException {
        this.wrappedStream.seek(position);
        this.bufferedStream = new ExtBufferedInputStream(this.wrappedStream, this.bufferSize);
        this.position = position;
    }

    @Override
    public int read() throws IOException {
        int b = this.bufferedStream.read();
        ++this.position;
        return b;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int nBytesRead = this.bufferedStream.read(buffer, offset, length);
        if (nBytesRead > 0) {
            int additionalBytesRead;
            if (nBytesRead < length && (additionalBytesRead = this.bufferedStream.read(buffer, nBytesRead + offset, length - nBytesRead)) > 0) {
                nBytesRead += additionalBytesRead;
            }
            this.position += (long)nBytesRead;
        }
        return nBytesRead;
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.wrappedStream.length();
    }

    @Override
    public String getSource() {
        return this.wrappedStream.getSource();
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    private class ExtBufferedInputStream
    extends BufferedInputStream {
        private ExtBufferedInputStream(InputStream inputStream, int i2) {
            super(inputStream, i2);
        }

        int getBytesInBufferAvailable() {
            return this.count - this.pos;
        }

        boolean canChangePos(long delta) {
            long newPos = (long)this.pos + delta;
            return newPos >= 0L && newPos < (long)this.count;
        }

        void changePos(int delta) {
            int newPos = this.pos + delta;
            if (newPos < 0 || newPos >= this.count) {
                throw new IllegalArgumentException("New position not in buffer pos=" + this.pos + ", delta=" + delta);
            }
            this.pos = newPos;
        }
    }
}

